/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Packet;
import jakarta.activation.DataHandler;
import jakarta.xml.ws.handler.MessageContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MessageContextImpl
implements MessageContext {
    private final Set<String> handlerScopeProps;
    private final Packet packet;
    private final Map<String, Object> asMapIncludingInvocationProperties;

    public MessageContextImpl(Packet packet) {
        this.packet = packet;
        this.asMapIncludingInvocationProperties = packet.asMapIncludingInvocationProperties();
        this.handlerScopeProps = packet.getHandlerScopePropertyNames(false);
    }

    protected void updatePacket() {
        throw new UnsupportedOperationException("wrong call");
    }

    @Override
    public void setScope(String name, MessageContext.Scope scope) {
        if (!this.containsKey(name)) {
            throw new IllegalArgumentException("Property " + name + " does not exist.");
        }
        if (scope == MessageContext.Scope.APPLICATION) {
            this.handlerScopeProps.remove(name);
        } else {
            this.handlerScopeProps.add(name);
        }
    }

    @Override
    public MessageContext.Scope getScope(String name) {
        if (!this.containsKey(name)) {
            throw new IllegalArgumentException("Property " + name + " does not exist.");
        }
        if (this.handlerScopeProps.contains(name)) {
            return MessageContext.Scope.HANDLER;
        }
        return MessageContext.Scope.APPLICATION;
    }

    @Override
    public int size() {
        return this.asMapIncludingInvocationProperties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.asMapIncludingInvocationProperties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.asMapIncludingInvocationProperties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.asMapIncludingInvocationProperties.containsValue(value);
    }

    @Override
    public Object put(String key, Object value) {
        if (!this.asMapIncludingInvocationProperties.containsKey(key)) {
            this.handlerScopeProps.add(key);
        }
        return this.asMapIncludingInvocationProperties.put(key, value);
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Object value = this.asMapIncludingInvocationProperties.get(key);
        if (key.equals("jakarta.xml.ws.binding.attachments.outbound") || key.equals("jakarta.xml.ws.binding.attachments.inbound")) {
            HashMap<String, DataHandler> atts = (HashMap<String, DataHandler>)value;
            if (atts == null) {
                atts = new HashMap<String, DataHandler>();
            }
            AttachmentSet attSet = this.packet.getMessage().getAttachments();
            for (Attachment att : attSet) {
                String cid = att.getContentId();
                if (!cid.contains("@jaxws.sun.com")) {
                    Object a = atts.get(cid);
                    if (a != null || (a = atts.get("<" + cid + ">")) != null) continue;
                    atts.put(att.getContentId(), att.asDataHandler());
                    continue;
                }
                atts.put(att.getContentId(), att.asDataHandler());
            }
            return atts;
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        for (String string : t.keySet()) {
            if (this.asMapIncludingInvocationProperties.containsKey(string)) continue;
            this.handlerScopeProps.add(string);
        }
        this.asMapIncludingInvocationProperties.putAll(t);
    }

    @Override
    public void clear() {
        this.asMapIncludingInvocationProperties.clear();
    }

    @Override
    public Object remove(Object key) {
        this.handlerScopeProps.remove(key);
        return this.asMapIncludingInvocationProperties.remove(key);
    }

    @Override
    public Set<String> keySet() {
        return this.asMapIncludingInvocationProperties.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.asMapIncludingInvocationProperties.entrySet();
    }

    @Override
    public Collection<Object> values() {
        return this.asMapIncludingInvocationProperties.values();
    }
}

