/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.provider;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.library.ClientType;
import org.gcube.common.authorization.library.provider.ClientInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserInfo
extends ClientInfo {
    private static final long serialVersionUID = 1L;
    private String clientId;
    private List<String> roles = new ArrayList<String>();
    private String email;
    private String firstName;
    private String lastName;

    protected UserInfo() {
    }

    public UserInfo(String clientId, List<String> roles) {
        this.clientId = clientId;
        this.roles = roles;
    }

    public UserInfo(String clientId, List<String> roles, String email, String firstName, String lastName) {
        this.clientId = clientId;
        this.roles = roles;
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Override
    public String getId() {
        return this.clientId;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
    }

    public String toString() {
        return "UserInfo [clientId=" + this.clientId + ", roles=" + this.roles + "]";
    }

    @Override
    public ClientType getType() {
        return ClientType.USER;
    }
}

