/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.storagehub.client.proxies.DefaultManagerClient;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

public class DefaultGroupManager
extends DefaultManagerClient
implements GroupManagerClient {
    public DefaultGroupManager(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
        super(delegate);
    }

    @Override
    public void addUserToGroup(final String userId, final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                formData.add("userId", userId);
                GXInboundResponse response = myManager.path(groupId).path("users").put(Entity.entity(formData, "application/x-www-form-urlencoded"));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void removeUserFromGroup(final String userId, final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.path(groupId).path("users").path(userId).delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<String> getGroups() throws StorageHubException {
        Call<GXWebTargetAdapterRequest, List<String>> call = new Call<GXWebTargetAdapterRequest, List<String>>(){

            @Override
            public List<String> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return response.getSource().readEntity(List.class);
            }
        };
        try {
            List<String> users = this.delegate.make(call);
            return users;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void removeGroup(final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.path(groupId).delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void createGroup(final String groupId, final AccessType accessType, final String folderOwner) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                try (FormDataMultiPart multipart = new FormDataMultiPart();){
                    multipart.field("accessType", (Object)accessType, MediaType.APPLICATION_JSON_TYPE);
                    multipart.field("group", groupId);
                    multipart.field("folderOwner", folderOwner);
                    GXInboundResponse response = myManager.post(Entity.entity(multipart, MediaType.MULTIPART_FORM_DATA_TYPE));
                    if (response.isErrorResponse()) {
                        if (response.hasException()) {
                            throw response.getException();
                        }
                        if (response.getHTTPCode() == 403) {
                            throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                        }
                        throw new BackendGenericError();
                    }
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<String> getUsersOfGroup(final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, List<String>> call = new Call<GXWebTargetAdapterRequest, List<String>>(){

            @Override
            public List<String> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.path(groupId).path("users").get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this methdo is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return response.getSource().readEntity(List.class);
            }
        };
        try {
            List<String> users = this.delegate.make(call);
            return users;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void addAdmin(final String groupId, final String userId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                formData.add("userId", userId);
                GXInboundResponse response = myManager.path(groupId).path("admins").put(Entity.entity(formData, "application/x-www-form-urlencoded"));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this methdo is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void removeAdmin(final String groupId, final String userId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.path(groupId).path("admins").path(userId).delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this methdo is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<String> getAdmins(final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, List<String>> call = new Call<GXWebTargetAdapterRequest, List<String>>(){

            @Override
            public List<String> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.path(groupId).path("admins").get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this methdo is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return response.getSource().readEntity(List.class);
            }
        };
        try {
            List<String> users = this.delegate.make(call);
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

