/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListRetriever;
import org.gcube.common.storagehub.client.dsl.Util;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;

public class ListResolver {
    ListRetriever retriever;
    ItemManagerClient itemClient;
    Set<String> excludes = new HashSet<String>(Arrays.asList("hl:accounting", "jcr:content", "hl:metadata"));
    Class<? extends Item> onlyType = null;
    boolean includeHidden = false;

    protected ListResolver(ListRetriever retriever, ItemManagerClient itemClient) {
        this.retriever = retriever;
        this.itemClient = itemClient;
    }

    public ListResolver withAccounting() {
        this.excludes.remove("hl:accounting");
        return this;
    }

    public ListResolver withContent() {
        this.excludes.remove("jcr:content");
        return this;
    }

    public ListResolver withMetadata() {
        this.excludes.remove("hl:metadata");
        return this;
    }

    public List<? extends Item> getItems() throws StorageHubException {
        List<? extends Item> list = this.retriever.getList(this.onlyType, this.includeHidden, this.excludes.toArray(new String[this.excludes.size()]));
        return list == null ? Collections.emptyList() : list;
    }

    public List<ItemContainer<? extends Item>> getContainers() throws StorageHubException {
        List<? extends Item> items = this.getItems();
        List<ItemContainer<? extends Item>> toReturn = items.stream().map(i -> Util.getContainerFromItem(i, this.itemClient)).collect(Collectors.toList());
        return toReturn;
    }
}

