/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scope.impl;

import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScopeProvider
implements ScopeProvider {
    public static final String SCOPE_PROPERTY = "gcube.scope";
    private static Logger log = LoggerFactory.getLogger(DefaultScopeProvider.class);
    private InheritableThreadLocal<String> scopes = new InheritableThreadLocal();

    protected DefaultScopeProvider() {
    }

    @Override
    public String get() {
        String scope = (String)this.scopes.get();
        if (scope == null) {
            scope = System.getProperty(SCOPE_PROPERTY);
        }
        return scope;
    }

    @Override
    public void set(String scope) {
        if (scope != null) {
            log.debug("setting scope {} in thread {}", (Object)scope, (Object)Thread.currentThread().getId());
        }
        this.scopes.set(scope);
    }

    @Override
    public void reset() {
        log.debug("resetting scope in thread {}", (Object)Thread.currentThread().getId());
        this.scopes.remove();
    }
}

