/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.storageApi;

import java.util.Iterator;
import java.util.concurrent.Future;
import org.cache2k.core.CacheInternalError;
import org.cache2k.core.CacheStorageException;
import org.cache2k.core.Entry;
import org.cache2k.core.storageApi.StorageEntry;

public abstract class StorageAdapter {
    public abstract void open();

    public abstract Future<Void> cancelTimerJobs();

    public abstract Future<Void> shutdown();

    public abstract void flush();

    public abstract void purge();

    public abstract void clear();

    public abstract boolean checkStorageStillDisconnectedForClear();

    public abstract void disconnectStorageForClear();

    public abstract Future<Void> clearAndReconnect();

    public abstract void put(Entry var1, long var2);

    public abstract StorageEntry get(Object var1);

    public abstract boolean remove(Object var1);

    public abstract void evict(Entry var1);

    public abstract void expire(Entry var1);

    public abstract Iterator<Entry> iterateAll();

    public abstract long getTotalEntryCount();

    public abstract int getAlert();

    public abstract void disable(Throwable var1);

    protected static Throwable buildThrowable(String txt, Throwable ex) {
        if (ex instanceof Error || ex.getCause() instanceof Error) {
            return new CacheInternalError(txt, ex);
        }
        return new CacheStorageException(txt, ex);
    }

    public static void rethrow(String txt, Throwable ex) {
        if (ex instanceof Error || ex.getCause() instanceof Error) {
            throw new CacheInternalError(txt, ex);
        }
        throw new CacheStorageException(txt, ex);
    }

    public static interface Parent {
        public void resetStorage(StorageAdapter var1, StorageAdapter var2);
    }
}

