/*
 * Decompiled with CFR 0.152.
 */
package lombok.delombok;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FormatPreferences {
    private final String indent;
    private final Boolean filledEmpties;
    private final boolean generateFinalParams;
    private final boolean generateConstructorProperties;
    private final boolean generateSuppressWarnings;
    private final boolean danceAroundIdeChecks;
    private final boolean generateDelombokComment;
    private final boolean javaLangAsFqn;
    final Map<String, String> rawMap;
    static final Map<String, String> KEYS;

    public FormatPreferences(Map<String, String> preferences) {
        this(preferences, null, null);
    }

    public FormatPreferences(Map<String, String> preferences, String indent, Boolean filledEmpties) {
        String empties_;
        String indent_;
        this.rawMap = preferences;
        if (preferences == null) {
            preferences = Collections.emptyMap();
        }
        if ((indent_ = preferences.get("indent")) != null && !"scan".equalsIgnoreCase(indent_)) {
            try {
                int id = Integer.parseInt(indent_);
                if (id > 0 && id < 32) {
                    char[] c = new char[id];
                    Arrays.fill(c, ' ');
                    indent_ = new String(c);
                }
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            indent = indent_.replace("\\t", "\t").replace("tab", "\t");
        }
        if ("indent".equalsIgnoreCase(empties_ = preferences.get("emptyLines".toLowerCase()))) {
            filledEmpties = true;
        } else if ("blank".equalsIgnoreCase(empties_)) {
            filledEmpties = false;
        } else if (empties_ != null && !"scan".equalsIgnoreCase(empties_)) {
            throw new IllegalArgumentException("Legal values for 'emptyLines' are 'scan', 'indent', or 'blank'.");
        }
        this.indent = indent;
        this.filledEmpties = filledEmpties;
        this.generateFinalParams = FormatPreferences.unrollBoolean(preferences, "finalParams", "generate", "skip", true);
        this.generateConstructorProperties = FormatPreferences.unrollBoolean(preferences, "constructorProperties", "generate", "skip", true);
        this.generateSuppressWarnings = FormatPreferences.unrollBoolean(preferences, "suppressWarnings", "generate", "skip", true);
        this.danceAroundIdeChecks = FormatPreferences.unrollBoolean(preferences, "danceAroundIdeChecks", "generate", "skip", true);
        this.generateDelombokComment = FormatPreferences.unrollBoolean(preferences, "generateDelombokComment", "generate", "skip", true);
        this.javaLangAsFqn = FormatPreferences.unrollBoolean(preferences, "javaLangAsFQN", "generate", "skip", true);
    }

    private static boolean unrollBoolean(Map<String, String> preferences, String name, String trueStr, String falseStr, boolean defaultVal) {
        String v_ = preferences.get(name.toLowerCase());
        if (v_ == null) {
            return defaultVal;
        }
        if (trueStr.equalsIgnoreCase(v_)) {
            return true;
        }
        if (falseStr.equalsIgnoreCase(v_)) {
            return false;
        }
        throw new IllegalArgumentException("Legal values for '" + name + "' are '" + trueStr + "', or '" + falseStr + "'.");
    }

    public static Map<String, String> getKeysAndDescriptions() {
        return KEYS;
    }

    public boolean fillEmpties() {
        return this.filledEmpties == null ? false : this.filledEmpties;
    }

    public String indent() {
        return this.indent == null ? "\t" : this.indent;
    }

    public boolean generateSuppressWarnings() {
        return this.generateSuppressWarnings;
    }

    public boolean generateFinalParams() {
        return this.generateFinalParams;
    }

    public boolean danceAroundIdeChecks() {
        return this.danceAroundIdeChecks;
    }

    public boolean generateDelombokComment() {
        return this.generateDelombokComment;
    }

    public boolean javaLangAsFqn() {
        return this.javaLangAsFqn;
    }

    public boolean generateConstructorProperties() {
        return this.generateConstructorProperties;
    }

    static {
        LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>();
        keys.put("indent", "The indent to use. 'tab' can be used to represent 1 tab. A number means that many spaces. Default: 'tab'");
        keys.put("emptyLines", "Either 'indent' or 'blank'. indent means: Indent an empty line to the right level. Default: 'blank'");
        keys.put("finalParams", "Either 'generate' or 'skip'. generate means: All lombok-generated methods set all parameters to final. Default: 'generate'");
        keys.put("constructorProperties", "Either 'generate' or 'skip'. generate means: All lombok-generated constructors with 1 or more arguments get an @ConstructorProperties annotation. Default: 'generate'");
        keys.put("suppressWarnings", "Either 'generate' or 'skip'. generate means: All lombok-generated methods get a @SuppressWarnings annotation. Default: 'generate'");
        keys.put("danceAroundIdeChecks", "Either 'generate' or 'skip'. generate means: Lombok will intentionally obfuscate some generated code to avoid IDE warnings. Default: 'generate'");
        keys.put("generateDelombokComment", "Either 'generate' or 'skip'. generate means: Any file modified by delombok will have a comment stating this at the top. Default: 'generate'");
        keys.put("javaLangAsFQN", "Either 'generate' or 'skip'. generate means: Any generated reference to java.lang classes are prefixed with `java.lang.`. Default: 'generate'");
        KEYS = Collections.unmodifiableMap(keys);
    }
}

