/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scan.scanners.url;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.gcube.common.scan.resources.ClasspathResource;
import org.gcube.common.scan.scanners.JarScanner;
import org.gcube.common.scan.scanners.url.URLScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJarURLScanner
implements URLScanner {
    private static Logger log = LoggerFactory.getLogger(AbstractJarURLScanner.class);
    private final JarScanner scanner = new JarScanner();

    @Override
    public Set<URL> additional(URL url) throws Exception {
        String classPath;
        Manifest manifest = this.toFile(url).getManifest();
        if (manifest != null && (classPath = manifest.getMainAttributes().getValue(new Attributes.Name("Class-Path"))) != null) {
            LinkedHashSet<URL> additionals = new LinkedHashSet<URL>();
            for (String entry : classPath.split(" ")) {
                try {
                    if (URI.create(entry).getScheme() == null) continue;
                    additionals.add(new URL(entry));
                }
                catch (Exception e) {
                    log.error("cannot process Class-Path entry " + entry, e);
                }
            }
            return additionals;
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<ClasspathResource> scan(URL url) throws Exception {
        return this.scanner.scan(this.toFile(url));
    }

    protected abstract JarFile toFile(URL var1) throws Exception;
}

