/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scan;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.scan.ClasspathScanner;
import org.gcube.common.scan.Configuration;
import org.gcube.common.scan.matchers.ResourceMatcher;
import org.gcube.common.scan.resources.ClasspathResource;
import org.gcube.common.scan.scanners.resource.ResourceScanner;
import org.gcube.common.scan.scanners.url.URLScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScanner
implements ClasspathScanner {
    private static Logger log = LoggerFactory.getLogger(DefaultScanner.class);
    private final Collection<URL> urls;

    public DefaultScanner() {
        this(DefaultScanner.defaultClasspath());
    }

    public DefaultScanner(Collection<URL> urls) {
        if (urls == null) {
            throw new IllegalArgumentException("no urls specified");
        }
        this.urls = urls;
    }

    @Override
    public Collection<ClasspathResource> scan(ResourceMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("no matcher specified");
        }
        long start = System.currentTimeMillis();
        Collection<ClasspathResource> scanned = this.scanUrls(this.urls, matcher);
        log.info("matched {} resources from {} urls in {} ms", scanned.size(), this.urls.size(), System.currentTimeMillis() - start);
        return scanned;
    }

    private Collection<ClasspathResource> scanUrls(Collection<URL> urls, ResourceMatcher matcher) {
        ArrayList<ClasspathResource> resources = new ArrayList<ClasspathResource>();
        block2: for (URL url : urls) {
            for (URLScanner scanner : Configuration.urlScanners) {
                if (!scanner.handles(url)) continue;
                try {
                    this.scanUrl(resources, url, scanner, matcher);
                }
                catch (Exception e) {
                    log.error("error scanning " + url, e);
                }
                continue block2;
            }
            log.warn("no handler for {}", (Object)url);
        }
        return resources;
    }

    private void scanUrl(Collection<ClasspathResource> results, URL url, URLScanner scanner, ResourceMatcher matcher) throws Exception {
        Collection<ClasspathResource> scanned = scanner.scan(url);
        results.addAll(this.scanResources(scanned, matcher));
        Set<URL> additionalUrls = scanner.additional(url);
        results.addAll(this.scanUrls(additionalUrls, matcher));
    }

    private Collection<ClasspathResource> scanResources(Collection<ClasspathResource> resources, ResourceMatcher matcher) {
        ArrayList<ClasspathResource> closure = new ArrayList<ClasspathResource>();
        block2: for (ClasspathResource resource : resources) {
            boolean handled = false;
            for (ResourceScanner scanner : Configuration.resourceScanners) {
                if (!scanner.handles(resource)) continue;
                handled = true;
                try {
                    Collection<ClasspathResource> scanned = this.scanResource(resource, scanner, matcher);
                    for (ClasspathResource r : scanned) {
                        if (!matcher.match(r)) continue;
                        closure.add(r);
                    }
                    continue block2;
                }
                catch (Exception e) {
                    log.warn("error scanning " + resource);
                    continue block2;
                }
            }
            if (handled || !matcher.match(resource)) continue;
            closure.add(resource);
        }
        return closure;
    }

    private Collection<ClasspathResource> scanResource(ClasspathResource resource, ResourceScanner scanner, ResourceMatcher matcher) throws Exception {
        Collection<ClasspathResource> scanned = scanner.scan(resource);
        return this.scanResources(scanned, matcher);
    }

    private static Set<URL> defaultClasspath() {
        HashSet<URL> result = new HashSet<URL>();
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            URL[] urls;
            if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
            result.addAll(new HashSet<URL>(Arrays.asList(urls)));
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(DefaultScanner.defaultClasspath());
    }
}

