/*
 * Decompiled with CFR 0.152.
 */
package ru.serce.jnrfuse;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.provider.jffi.ClosureHelper;
import jnr.posix.util.Platform;
import ru.serce.jnrfuse.FuseException;
import ru.serce.jnrfuse.FuseFS;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.LibFuse;
import ru.serce.jnrfuse.NotImplemented;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.Flock;
import ru.serce.jnrfuse.struct.FuseBufvec;
import ru.serce.jnrfuse.struct.FuseContext;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.FuseOperations;
import ru.serce.jnrfuse.struct.FusePollhandle;
import ru.serce.jnrfuse.struct.Statvfs;
import ru.serce.jnrfuse.struct.Timespec;
import ru.serce.jnrfuse.utils.MountUtils;
import ru.serce.jnrfuse.utils.SecurityUtils;
import ru.serce.jnrfuse.utils.WinPathUtils;

public abstract class AbstractFuseFS
implements FuseFS {
    private static final int TIMEOUT = 2000;
    private static final String[] osxFuseLibraries = new String[]{"fuse4x", "osxfuse", "macfuse", "fuse"};
    private Set<String> notImplementedMethods;
    protected final LibFuse libFuse;
    protected final FuseOperations fuseOperations;
    protected final AtomicBoolean mounted = new AtomicBoolean();
    protected Path mountPoint;
    private volatile Pointer fusePointer;

    public AbstractFuseFS() {
        jnr.ffi.Platform p = jnr.ffi.Platform.getNativePlatform();
        LibFuse libFuse = null;
        switch (p.getOS()) {
            case DARWIN: {
                for (String library : osxFuseLibraries) {
                    try {
                        libFuse = LibraryLoader.create(LibFuse.class).failImmediately().load(library);
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
                if (libFuse != null) break;
                libFuse = LibraryLoader.create(LibFuse.class).failImmediately().load("fuse");
                break;
            }
            case WINDOWS: {
                String winFspPath = WinPathUtils.getWinFspPath();
                libFuse = LibraryLoader.create(LibFuse.class).failImmediately().load(winFspPath);
                break;
            }
            default: {
                try {
                    libFuse = LibraryLoader.create(LibFuse.class).failImmediately().load("fuse");
                    break;
                }
                catch (Throwable e) {
                    libFuse = LibraryLoader.create(LibFuse.class).failImmediately().load("libfuse.so.2");
                }
            }
        }
        this.libFuse = libFuse;
        jnr.ffi.Runtime runtime = jnr.ffi.Runtime.getSystemRuntime();
        this.fuseOperations = new FuseOperations(runtime);
        this.init(this.fuseOperations);
    }

    public FuseContext getContext() {
        return this.libFuse.fuse_get_context();
    }

    private void init(FuseOperations fuseOperations) {
        this.notImplementedMethods = Arrays.stream(this.getClass().getMethods()).filter(method -> method.getAnnotation(NotImplemented.class) != null).map(Method::getName).collect(Collectors.toSet());
        AbstractFuseFS fuse = this;
        if (this.isImplemented("getattr")) {
            fuseOperations.getattr.set((path, stbuf) -> fuse.getattr(path, FileStat.of(stbuf)));
        }
        if (this.isImplemented("readlink")) {
            fuseOperations.readlink.set(fuse::readlink);
        }
        if (this.isImplemented("mknod")) {
            fuseOperations.mknod.set(fuse::mknod);
        }
        if (this.isImplemented("mkdir")) {
            fuseOperations.mkdir.set(fuse::mkdir);
        }
        if (this.isImplemented("unlink")) {
            fuseOperations.unlink.set(fuse::unlink);
        }
        if (this.isImplemented("rmdir")) {
            fuseOperations.rmdir.set(fuse::rmdir);
        }
        if (this.isImplemented("symlink")) {
            fuseOperations.symlink.set(fuse::symlink);
        }
        if (this.isImplemented("rename")) {
            fuseOperations.rename.set(fuse::rename);
        }
        if (this.isImplemented("link")) {
            fuseOperations.link.set(fuse::link);
        }
        if (this.isImplemented("chmod")) {
            fuseOperations.chmod.set(fuse::chmod);
        }
        if (this.isImplemented("chown")) {
            fuseOperations.chown.set(fuse::chown);
        }
        if (this.isImplemented("truncate")) {
            fuseOperations.truncate.set(fuse::truncate);
        }
        if (this.isImplemented("open")) {
            fuseOperations.open.set((path, fi) -> fuse.open(path, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("read")) {
            fuseOperations.read.set((path, buf, size, offset, fi) -> fuse.read(path, buf, size, offset, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("write")) {
            fuseOperations.write.set((path, buf, size, offset, fi) -> fuse.write(path, buf, size, offset, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("statfs")) {
            fuseOperations.statfs.set((path, stbuf) -> fuse.statfs(path, Statvfs.of(stbuf)));
        }
        if (this.isImplemented("flush")) {
            fuseOperations.flush.set((path, fi) -> fuse.flush(path, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("release")) {
            fuseOperations.release.set((path, fi) -> fuse.release(path, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("fsync")) {
            fuseOperations.fsync.set((path, isdatasync, fi) -> fuse.fsync(path, isdatasync, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("setxattr")) {
            fuseOperations.setxattr.set(fuse::setxattr);
        }
        if (this.isImplemented("getxattr")) {
            fuseOperations.getxattr.set(fuse::getxattr);
        }
        if (this.isImplemented("listxattr")) {
            fuseOperations.listxattr.set(fuse::listxattr);
        }
        if (this.isImplemented("removexattr")) {
            fuseOperations.removexattr.set(fuse::removexattr);
        }
        if (this.isImplemented("opendir")) {
            fuseOperations.opendir.set((path, fi) -> fuse.opendir(path, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("readdir")) {
            fuseOperations.readdir.set((path, buf, filter, offset, fi) -> {
                ClosureHelper helper = ClosureHelper.getInstance();
                FromNativeConverter<FuseFillDir, Pointer> conveter = helper.getNativeConveter(FuseFillDir.class);
                FuseFillDir filterFunc = conveter.fromNative(filter, helper.getFromNativeContext());
                return fuse.readdir(path, buf, filterFunc, offset, FuseFileInfo.of(fi));
            });
        }
        if (this.isImplemented("releasedir")) {
            fuseOperations.releasedir.set((path, fi) -> fuse.releasedir(path, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("fsyncdir")) {
            fuseOperations.fsyncdir.set((path, fi) -> fuse.fsyncdir(path, FuseFileInfo.of(fi)));
        }
        fuseOperations.init.set(conn -> {
            this.fusePointer = this.libFuse.fuse_get_context().fuse.get();
            if (this.isImplemented("init")) {
                return fuse.init(conn);
            }
            return null;
        });
        if (this.isImplemented("destroy")) {
            fuseOperations.destroy.set(fuse::destroy);
        }
        if (this.isImplemented("access")) {
            fuseOperations.access.set(fuse::access);
        }
        if (this.isImplemented("create")) {
            fuseOperations.create.set((path, mode, fi) -> fuse.create(path, mode, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("ftruncate")) {
            fuseOperations.ftruncate.set((path, size, fi) -> fuse.ftruncate(path, size, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("fgetattr")) {
            fuseOperations.fgetattr.set((path, stbuf, fi) -> fuse.fgetattr(path, FileStat.of(stbuf), FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("lock")) {
            fuseOperations.lock.set((path, fi, cmd, flock) -> fuse.lock(path, FuseFileInfo.of(fi), cmd, Flock.of(flock)));
        }
        if (this.isImplemented("utimens")) {
            fuseOperations.utimens.set((path, timespec) -> {
                Timespec timespec1 = Timespec.of(timespec);
                Timespec timespec2 = Timespec.of(timespec.slice(Struct.size(timespec1)));
                return fuse.utimens(path, new Timespec[]{timespec1, timespec2});
            });
        }
        if (this.isImplemented("bmap")) {
            fuseOperations.bmap.set((path, blocksize, idx) -> fuse.bmap(path, blocksize, idx.getLong(0L)));
        }
        if (this.isImplemented("ioctl")) {
            fuseOperations.ioctl.set((path, cmd, arg, fi, flags, data) -> fuse.ioctl(path, cmd, arg, FuseFileInfo.of(fi), flags, data));
        }
        if (this.isImplemented("poll")) {
            fuseOperations.poll.set((path, fi, ph, reventsp) -> fuse.poll(path, FuseFileInfo.of(fi), FusePollhandle.of(ph), reventsp));
        }
        if (this.isImplemented("write_buf")) {
            fuseOperations.write_buf.set((path, buf, off, fi) -> fuse.write_buf(path, FuseBufvec.of(buf), off, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("read_buf")) {
            fuseOperations.read_buf.set((path, bufp, size, off, fi) -> fuse.read_buf(path, bufp, size, off, FuseFileInfo.of(fi)));
        }
        if (this.isImplemented("flock")) {
            fuseOperations.flock.set((path, fi, op) -> fuse.flock(path, FuseFileInfo.of(fi), op));
        }
        if (this.isImplemented("fallocate")) {
            fuseOperations.fallocate.set((path, mode, off, length, fi) -> fuse.fallocate(path, mode, off, length, FuseFileInfo.of(fi)));
        }
    }

    @Override
    public void mount(Path mountPoint, boolean blocking, boolean debug, String[] fuseOpts) {
        if (!this.mounted.compareAndSet(false, true)) {
            throw new FuseException("Fuse fs already mounted!");
        }
        this.mountPoint = mountPoint;
        String mountPointStr = mountPoint.toAbsolutePath().toString();
        if (mountPointStr.endsWith("\\")) {
            mountPointStr = mountPointStr.substring(0, mountPointStr.length() - 1);
        }
        String[] arg = !debug ? new String[]{this.getFSName(), "-f", mountPointStr} : new String[]{this.getFSName(), "-f", "-d", mountPointStr};
        if (fuseOpts.length != 0) {
            int argLen = arg.length;
            arg = Arrays.copyOf(arg, argLen + fuseOpts.length);
            System.arraycopy(fuseOpts, 0, arg, argLen, fuseOpts.length);
        }
        String[] args = arg;
        try {
            int res;
            if (SecurityUtils.canHandleShutdownHooks()) {
                Runtime.getRuntime().addShutdownHook(new Thread(this::umount));
            }
            if (blocking) {
                res = this.execMount(args);
            } else {
                CompletableFuture mountResult = new CompletableFuture();
                Thread mountThread = new Thread(() -> {
                    try {
                        mountResult.complete(this.execMount(args));
                    }
                    catch (Throwable t) {
                        mountResult.completeExceptionally(t);
                    }
                }, "jnr-fuse-mount-thread");
                mountThread.setDaemon(true);
                mountThread.start();
                try {
                    res = (Integer)mountResult.get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    res = 0;
                }
            }
            if (res != 0) {
                throw new FuseException("Unable to mount FS, return code = " + res);
            }
        }
        catch (Exception e) {
            this.mounted.set(false);
            throw new FuseException("Unable to mount FS", e);
        }
    }

    private boolean isImplemented(String funcName) {
        return !this.notImplementedMethods.contains(funcName);
    }

    private int execMount(String[] arg) {
        return this.libFuse.fuse_main_real(arg.length, arg, this.fuseOperations, Struct.size(this.fuseOperations), null);
    }

    @Override
    public void umount() {
        if (!this.mounted.get()) {
            return;
        }
        if (Platform.IS_WINDOWS) {
            Pointer fusePointer = this.fusePointer;
            if (fusePointer != null) {
                this.libFuse.fuse_exit(fusePointer);
            }
        } else {
            MountUtils.umount(this.mountPoint);
        }
        this.mounted.set(false);
    }

    protected String getFSName() {
        return "fusefs" + ThreadLocalRandom.current().nextInt();
    }
}

