/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.builders;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.gcube.common.clients.cache.EndpointCache;
import org.gcube.common.clients.config.DiscoveryConfig;
import org.gcube.common.clients.config.EndpointConfig;
import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.delegates.AbstractDelegate;
import org.gcube.common.clients.delegates.DirectDelegate;
import org.gcube.common.clients.delegates.DiscoveryDelegate;
import org.gcube.common.clients.delegates.ProxyPlugin;
import org.gcube.common.clients.queries.Query;

public abstract class AbstractBuilder<A, S, P> {
    public static final int defaultTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
    private final ProxyPlugin<A, S, P> plugin;
    private Query<A> query;
    private W3CEndpointReference address;
    private final EndpointCache<A> cache;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    protected AbstractBuilder(ProxyPlugin<A, S, P> plugin, EndpointCache<A> cache, Property<?> ... properties) {
        this.plugin = plugin;
        this.cache = cache;
        this.setTimeout(defaultTimeout);
        for (Property<?> property : properties) {
            this.addProperty(property);
        }
    }

    protected ProxyPlugin<A, S, P> plugin() {
        return this.plugin;
    }

    protected void setQuery(Query<A> query) {
        this.query = query;
    }

    protected void setTimeout(int timeout) {
        this.addProperty(Property.timeout(timeout));
    }

    protected void setAddress(W3CEndpointReference address) {
        this.address = address;
    }

    protected void addProperty(Property<?> property) {
        this.properties.put(property.name(), property.value());
    }

    public P build() {
        AbstractDelegate delegate = null;
        if (this.address == null) {
            DiscoveryConfig<A, S> config = new DiscoveryConfig<A, S>(this.plugin, this.query, this.cache);
            for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
                config.addProperty(prop.getKey(), prop.getValue());
            }
            delegate = new DiscoveryDelegate<A, S>(config);
        } else {
            EndpointConfig<A, S> config = new EndpointConfig<A, S>(this.plugin, this.convertAddress(this.address));
            for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
                config.addProperty(prop.getKey(), prop.getValue());
            }
            delegate = new DirectDelegate<A, S>(config);
        }
        return this.plugin.newProxy(delegate);
    }

    protected abstract A convertAddress(W3CEndpointReference var1);

    protected abstract String contextPath();
}

