package org.gcube.data.access.storagehub.fs;

import jnr.ffi.Pointer;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.struct.FileStat;

public interface SHFile {

	default int read(Pointer buf, @size_t long size, @off_t long offset) {
		return -ErrorCodes.ENOSYS();
	}
	
	default int write(Pointer buf, long size, long offset) {
		return -ErrorCodes.ENOSYS();
	}
	
	int flush();
	
	int getAttr(FileStat stat);
}
