/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.fs;

import java.io.IOException;
import java.io.InputStream;
import jnr.ffi.Pointer;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.data.access.storagehub.fs.SHFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.struct.FileStat;

public class FileDownload
implements SHFile {
    public static Logger logger = LoggerFactory.getLogger(FileDownload.class);
    InputStream stream;
    AbstractFileItem fileItem;

    public FileDownload(FileContainer fileContainer) throws Exception {
        this.stream = fileContainer.download(new String[0]).getStream();
        this.fileItem = (AbstractFileItem)fileContainer.get();
        logger.trace("FILE-DOWNLOAD initialized with {} , {}", (Object)this.fileItem.getName(), (Object)this.fileItem.getContent().getSize());
    }

    @Override
    public synchronized int read(Pointer buf, @size_t long size, @off_t long offset) {
        int readTotal;
        logger.trace("read called with size {} and offset {} ", (Object)size, (Object)offset);
        int bytesToRead = (int)size;
        byte[] mybuf = new byte[bytesToRead];
        try {
            int read = 0;
            for (readTotal = 0; (read = this.stream.read(mybuf, 0, bytesToRead - readTotal)) != -1 && bytesToRead > readTotal; readTotal += read) {
                buf.put(0L, mybuf, 0, read);
            }
            logger.trace("bytes to read {} and read total {} and last read {}", bytesToRead, readTotal, read);
        }
        catch (Exception e) {
            logger.error("error in read", e);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -ErrorCodes.ENOENT();
        }
        return readTotal;
    }

    @Override
    public synchronized int flush() {
        logger.trace("called flush");
        try {
            this.stream.close();
        }
        catch (IOException e1) {
            logger.error("error closing stream", e1);
        }
        return 0;
    }

    @Override
    public int getAttr(FileStat stat) {
        logger.trace("is in download");
        stat.st_mode.set(33133);
        stat.st_size.set(this.fileItem.getContent().getSize());
        stat.st_mtim.tv_sec.set(this.fileItem.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_mtim.tv_nsec.set(this.fileItem.getLastModificationTime().toInstant().getNano());
        stat.st_ctim.tv_sec.set(this.fileItem.getCreationTime().toInstant().getEpochSecond());
        stat.st_ctim.tv_nsec.set(this.fileItem.getCreationTime().toInstant().getNano());
        stat.st_atim.tv_sec.set(this.fileItem.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_atim.tv_nsec.set(this.fileItem.getLastModificationTime().toInstant().getNano());
        return 0;
    }
}

