/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scope.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.gcube.common.scan.ClasspathScanner;
import org.gcube.common.scan.ClasspathScannerFactory;
import org.gcube.common.scan.matchers.NameMatcher;
import org.gcube.common.scan.resources.ClasspathResource;
import org.gcube.common.scope.api.ServiceMap;
import org.gcube.common.scope.impl.DefaultServiceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceMapScanner {
    private static Logger log = LoggerFactory.getLogger(ServiceMapScanner.class);
    static final String mapConfigPattern = ".*\\.servicemap";

    ServiceMapScanner() {
    }

    static Map<String, ServiceMap> maps() {
        HashMap<String, ServiceMap> maps = new HashMap<String, ServiceMap>();
        try {
            Set<String> resources = ServiceMapScanner.getMapNames();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DefaultServiceMap.class});
            Unmarshaller um = context.createUnmarshaller();
            for (String resource : resources) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
                log.info("loading {} with resource name {}", (Object)url, (Object)resource);
                if (url == null) {
                    log.info("resource discarded because it is null");
                    continue;
                }
                DefaultServiceMap map = (DefaultServiceMap)um.unmarshal(url);
                ServiceMap current = (ServiceMap)maps.get(map.scope());
                if (current != null && current.version() != null) {
                    if (current.version().compareToIgnoreCase(map.version()) == 1) {
                        log.warn("discarding {} because older (v.{}) than one previously loaded (v.{}) for {} ", url, map.version(), current.version(), map.scope());
                        continue;
                    }
                    log.info("overwriting older map (v.{}) with newer map (v.{}) for {} ", current.version(), map.version(), map.scope());
                }
                maps.put(map.scope(), map);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could not load service maps", e);
        }
        return maps;
    }

    private static Set<String> getMapNames() {
        ClasspathScanner scanner = ClasspathScannerFactory.scanner();
        HashSet<String> names = new HashSet<String>();
        for (ClasspathResource r : scanner.scan(new NameMatcher(mapConfigPattern))) {
            names.add(r.name());
        }
        return names;
    }
}

