/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.gcube.common.clients.stubs.jaxws.GCoreEndpointReference;
import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.clients.stubs.jaxws.StubCache;
import org.gcube.common.clients.stubs.jaxws.StubFactoryDSL;
import org.gcube.common.clients.stubs.jaxws.handlers.GCoreJAXWSHandler;
import org.gcube.common.clients.stubs.jaxws.proxies.GenericProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubFactory<T>
implements StubFactoryDSL.AtClause<T> {
    private static final Logger log = LoggerFactory.getLogger(StubFactory.class);
    private static String proxyHost;
    private static int proxyPort;
    private static StubCache cache;
    private final GCoreService<T> target;

    public StubFactory(GCoreService<T> target) {
        JAXWSUtils.notNull("gCore Service", target);
        this.target = target;
    }

    @Override
    public T at(EndpointReference reference) {
        JAXWSUtils.notNull("instance reference", reference);
        GCoreEndpointReference epr = new GCoreEndpointReference(reference);
        String proxied = this.setProxyOn(epr.address);
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder().address(proxied);
        reference = epr.key == null ? builder.build() : builder.referenceParameter(epr.key).build();
        return this.at(proxied, reference, new AddressingFeature());
    }

    @Override
    public T at(URI address) {
        JAXWSUtils.notNull("endpoint address", address);
        W3CEndpointReference reference = new W3CEndpointReferenceBuilder().address(address.toString()).build();
        return this.at((EndpointReference)reference);
    }

    private T at(String endpointAddress, EndpointReference reference, AddressingFeature ... features) {
        try {
            Service service = this.buildService(endpointAddress + "?wsdl", this.target.type(), this.target.qName());
            log.info("target type is {} ", (Object)this.target.type());
            Thread.currentThread().setContextClassLoader(StubFactory.class.getClassLoader());
            Object stub = service.getPort(reference, this.target.type(), (WebServiceFeature[])features);
            BindingProvider provider = (BindingProvider)stub;
            this.registerHandler(provider, this.target);
            return GenericProxyFactory.getProxy(this.target.type(), endpointAddress, stub);
        }
        catch (Error e) {
            cache.clear(this.target.type());
            throw new RuntimeException("could not configure discovery service", e);
        }
        catch (Exception e) {
            throw new RuntimeException("could not configure discovery service", e);
        }
    }

    public static <T> StubFactoryDSL.AtClause<T> stubFor(GCoreService<T> service) {
        return new StubFactory<T>(service);
    }

    private synchronized Service buildService(final String wsdlAddress, Class<?> type, final QName name) throws Exception {
        Callable<Service> task = new Callable<Service>(){

            @Override
            public Service call() throws Exception {
                log.info("fetching wsdl for {} at {}", (Object)name.getLocalPart(), (Object)wsdlAddress);
                return Service.create((URL)new URL(wsdlAddress), (QName)name);
            }
        };
        Service service = cache.get(type, task);
        return service;
    }

    private void registerHandler(BindingProvider provider, GCoreService<?> context) {
        Binding binding = provider.getBinding();
        List currentChain = binding.getHandlerChain();
        GCoreJAXWSHandler handler = new GCoreJAXWSHandler(context);
        currentChain.add(handler);
        binding.setHandlerChain(currentChain);
    }

    public static void setProxy(String host, int port) {
        proxyHost = host;
        proxyPort = port;
    }

    private String setProxyOn(String address) {
        if (proxyHost != null) {
            try {
                URI u = URI.create(address);
                return new URI(u.getScheme(), u.getUserInfo(), proxyHost, proxyPort, u.getPath(), u.getQuery(), u.getFragment()).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return address;
    }

    static {
        cache = new StubCache();
    }
}

