/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.cfg;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import java.lang.annotation.Annotation;

public abstract class EndpointConfigBase<THIS extends EndpointConfigBase<THIS>> {
    protected Class<?> _activeView;
    protected String _rootName;
    protected DeserializationFeature[] _deserEnable;
    protected DeserializationFeature[] _deserDisable;
    protected ObjectReader _reader;
    protected SerializationFeature[] _serEnable;
    protected SerializationFeature[] _serDisable;
    protected ObjectWriter _writer;

    protected EndpointConfigBase() {
    }

    protected THIS add(Annotation[] annotationArray, boolean bl) {
        if (annotationArray != null) {
            for (Annotation annotation : annotationArray) {
                this.addAnnotation(annotation.annotationType(), annotation, bl);
            }
        }
        return (THIS)this;
    }

    protected void addAnnotation(Class<? extends Annotation> clazz, Annotation annotation, boolean bl) {
        JacksonAnnotationsInside jacksonAnnotationsInside;
        if (clazz == JsonView.class) {
            Class<?>[] classArray = ((JsonView)annotation).value();
            this._activeView = classArray.length > 0 ? classArray[0] : null;
        } else if (clazz == JacksonFeatures.class) {
            JacksonFeatures jacksonFeatures = (JacksonFeatures)annotation;
            if (bl) {
                this._serEnable = EndpointConfigBase.nullIfEmpty(jacksonFeatures.serializationEnable());
                this._serDisable = EndpointConfigBase.nullIfEmpty(jacksonFeatures.serializationDisable());
            } else {
                this._deserEnable = EndpointConfigBase.nullIfEmpty(jacksonFeatures.deserializationEnable());
                this._deserDisable = EndpointConfigBase.nullIfEmpty(jacksonFeatures.deserializationDisable());
            }
        } else if (clazz == JsonRootName.class) {
            this._rootName = ((JsonRootName)annotation).value();
        } else if (clazz != JacksonAnnotationsInside.class && (jacksonAnnotationsInside = clazz.getAnnotation(JacksonAnnotationsInside.class)) != null) {
            this.add(clazz.getAnnotations(), bl);
        }
    }

    protected THIS initReader(ObjectReader objectReader) {
        if (this._activeView != null) {
            objectReader = objectReader.withView(this._activeView);
        }
        if (this._rootName != null) {
            objectReader = objectReader.withRootName(this._rootName);
        }
        if (this._deserEnable != null) {
            objectReader = objectReader.withFeatures(this._deserEnable);
        }
        if (this._deserDisable != null) {
            objectReader = objectReader.withoutFeatures(this._deserDisable);
        }
        this._reader = objectReader;
        return (THIS)this;
    }

    protected THIS initWriter(ObjectWriter objectWriter) {
        if (this._activeView != null) {
            objectWriter = objectWriter.withView(this._activeView);
        }
        if (this._rootName != null) {
            objectWriter = objectWriter.withRootName(this._rootName);
        }
        if (this._serEnable != null) {
            objectWriter = objectWriter.withFeatures(this._serEnable);
        }
        if (this._serDisable != null) {
            objectWriter = objectWriter.withoutFeatures(this._serDisable);
        }
        this._writer = objectWriter;
        return (THIS)this;
    }

    public String getRootName() {
        return this._rootName;
    }

    public Class<?> getActiveView() {
        return this._activeView;
    }

    public final ObjectReader getReader() {
        if (this._reader == null) {
            throw new IllegalStateException();
        }
        return this._reader;
    }

    public final ObjectWriter getWriter() {
        if (this._writer == null) {
            throw new IllegalStateException();
        }
        return this._writer;
    }

    public abstract Object modifyBeforeWrite(Object var1);

    protected static <T> T[] nullIfEmpty(T[] TArray) {
        if (TArray == null || TArray.length == 0) {
            return null;
        }
        return TArray;
    }
}

