/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.porttypes;

import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.service.Consumer;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class GCUBEPortType
implements ServiceLifecycle {
    protected final GCUBELog logger = new GCUBELog(this);
    protected boolean initialized;

    public final void init(Object arg0) throws ServiceException {
        if (this.initialized || this.getServiceContext().getStatus() == GCUBEServiceContext.Status.FAILED) {
            return;
        }
        try {
            this.getServiceContext().subscribeLifetTime(new PortTypeConsumer(), new GCUBEServiceContext.RILifetimeTopic[0]);
        }
        catch (Exception e) {
            this.logger.error("could not register port-type " + this.getClass().getSimpleName() + " with running instance", e);
        }
        this.initialized = true;
    }

    protected abstract GCUBEServiceContext getServiceContext();

    public void destroy() {
    }

    protected void onInitialisation() throws Exception {
    }

    protected void onReady() throws Exception {
    }

    protected void onFailure() throws Exception {
    }

    protected void onUpdate() throws Exception {
    }

    protected void onStateChange() throws Exception {
    }

    class PortTypeConsumer
    extends Consumer {
        PortTypeConsumer() {
        }

        @Override
        protected void onRIInitialised(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIInitialised(event);
            GCUBEPortType.this.logger.setContext(GCUBEPortType.this.getServiceContext());
            GCUBEPortType.this.logger.trace("INITIALISING PORTTYPE " + GCUBEPortType.this.getClass().getSimpleName().toUpperCase());
            GCUBEPortType.this.onInitialisation();
        }

        @Override
        protected void onRIReady(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIReady(event);
            GCUBEPortType.this.onReady();
        }

        @Override
        protected void onRIStateChange(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIStateChange(event);
            GCUBEPortType.this.onStateChange();
        }

        @Override
        protected void onRIUpdated(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIUpdated(event);
            GCUBEPortType.this.onUpdate();
        }

        @Override
        protected void onRIFailed(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIFailed(event);
            GCUBEPortType.this.onFailure();
        }
    }
}

