/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.plugins;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.gcube.common.core.contexts.GCUBEPortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.service.Builder;
import org.gcube.common.core.plugins.GCUBEPluginContext;
import org.gcube.common.core.plugins.GCUBEPluginManagerProfile;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Plugin;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.config.ContainerConfig;

public abstract class GCUBEPluginManager<PLUGINCONTEXT extends GCUBEPluginContext> {
    protected GCUBELog logger = new GCUBELog(this);
    public static final String PLUGINS_DIRECTORY_NAME = "plugins";
    protected GCUBEServiceContext context;
    protected Map<String, PLUGINCONTEXT> plugins = new HashMap<String, PLUGINCONTEXT>();
    protected static final String PLUGIN_PROFILE_SUFFIX = ".profile";
    protected GCUBEProducer<PluginTopic, PLUGINCONTEXT> producer = new GCUBEProducer();

    public void setLogger(GCUBELog logger) {
        this.logger = logger;
    }

    public void initialise(GCUBEServiceContext context, GCUBEPluginManagerProfile managerProfile) throws Exception {
        this.context = context;
        File[] plugins = this.context.getPersistentFile(PLUGINS_DIRECTORY_NAME, new boolean[0]).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(GCUBEPluginManager.PLUGIN_PROFILE_SUFFIX);
            }
        });
        if (plugins != null) {
            for (File profile : plugins) {
                try {
                    GCUBEService plugin = GHNContext.getImplementation(GCUBEService.class);
                    plugin.load(new FileReader(profile));
                    this.registerPlugin(plugin, false);
                }
                catch (Exception e) {
                    this.logger.warn("could not register plugin in " + profile, e);
                }
            }
        }
    }

    protected abstract Class<PLUGINCONTEXT> getMainClass();

    public PLUGINCONTEXT validateMainClass(Class<?> contextClass) throws Exception {
        if (!this.getMainClass().isAssignableFrom(contextClass)) {
            throw new Exception(contextClass.getSimpleName() + " is not a subclass of " + GCUBEPluginContext.class.getSimpleName());
        }
        try {
            return (PLUGINCONTEXT)((GCUBEPluginContext)contextClass.newInstance());
        }
        catch (Exception e) {
            throw new Exception(contextClass.getSimpleName() + " cannot be reflectively instantiated", e);
        }
    }

    public Map<String, PLUGINCONTEXT> getPlugins() {
        return Collections.unmodifiableMap(this.plugins);
    }

    public synchronized void registerPlugin(GCUBEService plugin, boolean ... persisted) throws PluginAlreadyRegisteredException, Exception {
        if (plugin == null) {
            throw new IllegalArgumentException();
        }
        if (this.plugins.containsKey(plugin.getServiceName())) {
            throw new PluginAlreadyRegisteredException("plugin " + plugin.getServiceName() + " already registered");
        }
        String mainClassName = null;
        try {
            mainClassName = ((Plugin)plugin.getPackages().get(0)).getEntryPoint();
        }
        catch (Exception e) {
            throw new Exception("invalid plugin: could not find main class", e);
        }
        Class<?> mainClass = null;
        try {
            mainClass = Thread.currentThread().getContextClassLoader().loadClass(mainClassName);
        }
        catch (Exception e) {
            throw new Exception("class " + mainClassName + " not on classpath", e);
        }
        GCUBEPluginContext context = null;
        try {
            context = (GCUBEPluginContext)this.validateMainClass(mainClass);
        }
        catch (Exception e) {
            throw new Exception(mainClass.getSimpleName() + " is not compatible with " + this.getMainClass().getSimpleName() + " expected by " + this.context.getName(), e);
        }
        context.initialise(plugin);
        WSDDEngineConfiguration engineConfig = (WSDDEngineConfiguration)ContainerConfig.getEngine().getConfig();
        for (GCUBEPortTypeContext ptContext : this.getPortTypeContexts()) {
            SOAPService service = engineConfig.getDeployment().getService(new QName(ptContext.getJNDIName()));
            TypeMappingRegistry registry = service.getTypeMappingRegistry();
            if (registry == null) continue;
            for (GCUBEPluginContext.TypeMapping mapping : context.getTypeMappings()) {
                try {
                    registry.getTypeMapping("").register(mapping.clazz, mapping.qname, mapping.sFactory, mapping.dfactory);
                    this.logger.info("registered type mapping for " + mapping.clazz.getSimpleName() + " on " + ptContext.getName());
                }
                catch (Exception e) {
                    this.logger.warn("could not register plugin type mapping for " + mapping.clazz.getSimpleName() + " on " + ptContext.getName(), e);
                }
            }
        }
        if (persisted == null || persisted.length == 0 || persisted[0]) {
            plugin.store(new FileWriter(this.context.getPersistentFile(PLUGINS_DIRECTORY_NAME + File.separatorChar + plugin.getServiceName() + PLUGIN_PROFILE_SUFFIX, true)));
        }
        this.plugins.put(plugin.getServiceName(), context);
        this.producer.notify(PluginTopic.REGISTRATION, new PluginEvent(this, context));
        new Builder(this.context).addPlugin(plugin);
        this.context.setStatus(GCUBEServiceContext.Status.UPDATED);
        this.logger.info("registered plugin " + plugin.getServiceName());
    }

    public synchronized void deregisterPlugin(String name) throws Exception {
        GCUBEPluginContext context = (GCUBEPluginContext)this.plugins.get(name);
        if (context == null) {
            throw new Exception("plugin " + name + " is not registered");
        }
        if (!this.context.getPersistentFile(PLUGINS_DIRECTORY_NAME + File.separatorChar + name + PLUGIN_PROFILE_SUFFIX, true).delete()) {
            throw new Exception("Plugin could not be removed form persisted store");
        }
        this.plugins.remove(name);
        new Builder(this.context).removePlugin(context.getPlugin());
        this.context.setStatus(GCUBEServiceContext.Status.UPDATED);
        this.producer.notify(PluginTopic.DEREGISTRATION, new PluginEvent(this, context));
    }

    protected abstract GCUBEPortTypeContext[] getPortTypeContexts();

    public void subscribe(PluginConsumer<PLUGINCONTEXT> c, PluginTopic ... topics) {
        this.producer.subscribe(c, topics.length == 0 ? PluginTopic.values() : topics);
    }

    public void unsubscribe(PluginConsumer<PLUGINCONTEXT> c, PluginTopic ... topics) {
        this.producer.subscribe(c, topics.length == 0 ? PluginTopic.values() : topics);
    }

    public static class PluginAlreadyRegisteredException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PluginAlreadyRegisteredException(String msg) {
            super(msg);
        }
    }

    public static class PluginConsumer<PLUGINCONTEXT extends GCUBEPluginContext>
    implements GCUBEConsumer<PluginTopic, PLUGINCONTEXT> {
        @Override
        public <T1 extends PluginTopic, P1 extends PLUGINCONTEXT> void onEvent(GCUBEEvent<T1, P1> ... events) {
            block4: for (GCUBEEvent<T1, P1> event : events) {
                PluginTopic topic = (PluginTopic)event.getTopic();
                switch (topic) {
                    case REGISTRATION: {
                        this.onRegistration(event);
                        continue block4;
                    }
                    case DEREGISTRATION: {
                        this.onDeregistration(event);
                    }
                }
            }
        }

        protected void onRegistration(GCUBEEvent<? extends PluginTopic, ? extends PLUGINCONTEXT> event) {
        }

        protected void onDeregistration(GCUBEEvent<? extends PluginTopic, ? extends PLUGINCONTEXT> event) {
        }
    }

    public static class PluginEvent
    extends GCUBEEvent<PluginTopic, PLUGINCONTEXT> {
        final /* synthetic */ GCUBEPluginManager this$0;

        PluginEvent(PLUGINCONTEXT c) {
            this.this$0 = var1_1;
            this.setPayload(c);
        }
    }

    public static enum PluginTopic implements GCUBETopic
    {
        REGISTRATION,
        DEREGISTRATION;

    }
}

