/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.handlers;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.PolicyUtils;
import org.gcube.common.authorization.library.policies.Policy;
import org.gcube.common.authorization.library.policies.ServiceAccess;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.ServiceIdentifier;
import org.gcube.common.authorization.library.provider.ServiceInfo;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBEServiceAuthenticationController;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.utils.InnerMethodName;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.records.Record;

public class GCUBEHandler
extends BasicHandler {
    public static final String SERVICECONTEXT_PROPERTY = "receiver";
    public static final String CALLER_PROPERTY = "caller";
    protected static GCUBELog logger = new GCUBELog(GCUBEHandler.class);
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<Long> startCallThreadLocal = new ThreadLocal();

    public void invoke(MessageContext mc) throws GCUBEFault {
        GCUBEServiceContext context;
        logger.debug("GCube Handler invoked");
        if (mc.getPastPivot()) {
            logger.trace("Past Pivot");
            this.onResponse(mc, new boolean[0]);
            return;
        }
        startCallThreadLocal.set(System.currentTimeMillis());
        SOAPHeader header = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            logger.trace("Getting headers");
            header = MessageContext.getCurrentContext().getCurrentMessage().getSOAPHeader();
        }
        catch (SOAPException e1) {
            throw new GCUBEUnrecoverableFault("call is malformed: could not process headers");
        }
        Iterator i = header.getChildElements();
        while (i.hasNext()) {
            SOAPElement child = (SOAPElement)i.next();
            String name = child.getElementName().getLocalName();
            String value = child.getValue();
            logger.trace("Header name = " + name + " value " + value);
            headers.put(name, value);
        }
        String calledMethod = headers.get("gcube-method") != null ? (String)headers.get("gcube-method") : "UNKNOWN";
        InnerMethodName.instance.set(calledMethod);
        if (!(headers.get("serviceClass") != null && headers.get("serviceName") != null || GHNContext.getContext().isSecurityEnabled())) {
            logger.debug("Security not enabled: the call without service header passes");
            return;
        }
        if ((headers.get("serviceClass") == null || headers.get("serviceName") == null) && GHNContext.getContext().isSecurityEnabled()) {
            logger.error("Unable to determine the correct service security configuration and to find the correct security controller: the calla will not pass");
            throw new GCUBEUnrecoverableException("Unable to determine the service").toFault(new String[0]);
        }
        try {
            context = GHNContext.getContext().getServiceContext((String)headers.get("serviceClass"), (String)headers.get("serviceName"));
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException(e).toFault("Could not dispatch gCube call to service " + (String)headers.get("serviceName"));
        }
        if (context.getStatus() == GCUBEServiceContext.Status.FAILED || context.getStatus() == GCUBEServiceContext.Status.DOWN) {
            throw new GCUBERetryEquivalentFault("Service " + (String)headers.get("serviceName") + " is not operational");
        }
        if (context.getStatus() != GCUBEServiceContext.Status.READIED) {
            throw new GCUBERetrySameFault("Service " + (String)headers.get("serviceName") + " is not ready yet");
        }
        mc.setProperty(SERVICECONTEXT_PROPERTY, (Object)context);
        try {
            String caller = (String)headers.get(CALLER_PROPERTY);
            mc.setProperty(CALLER_PROPERTY, (Object)caller);
            String target = context.getServiceClass() + ":" + context.getName() + ":" + InnerMethodName.instance.get();
            String token = (String)headers.get("gcube-token");
            if (headers.get("scope") != null) {
                GCUBEScope scope = GCUBEScope.getScope((String)headers.get("scope"));
                logger.trace("Scope = " + scope);
                context.setScope(scope);
                if (GHNContext.getContext().isSecurityEnabled()) {
                    logger.trace("peer subject " + mc.getProperty("callerSubject"));
                    logger.trace("Setting security");
                    HashMap<String, Object> securityParameterMap = new HashMap<String, Object>();
                    securityParameterMap.put("CONTEXT", context);
                    securityParameterMap.put("HEADERS", headers);
                    securityParameterMap.put("MESSAGE_CONTEXT", mc);
                    GCUBEServiceAuthenticationController authenticationManager = context.getAuthenticationManager();
                    GCUBEServiceAuthorizationController authorizationManager = context.getAuthorizationManager();
                    authenticationManager.authenticateCall(securityParameterMap);
                    authorizationManager.authoriseCall(securityParameterMap);
                    logger.trace("Security set");
                }
                if (token != null) {
                    AuthorizationEntry info = this.retrieveTokenInfo(token);
                    this.checkPolicies(info, context);
                    AuthorizationProvider.instance.set(new Caller(info.getClientInfo(), info.getQualifier()));
                    SecurityTokenProvider.instance.set(token);
                }
            } else if (!this.validateToken(token, caller, context)) {
                throw new Exception("gCube call is unscoped");
            }
            logger.info("START CALL FROM (" + caller + ") TO (" + target + ")," + ScopeProvider.instance.get() + "," + Thread.currentThread());
        }
        catch (GCUBEException e) {
            logger.error("Error in GCubeHandler", e);
            this.onResponse(mc, new boolean[0]);
            throw e.toFault(new String[0]);
        }
        catch (Exception e) {
            logger.error("General exception in GCubeHandler", e);
            this.onResponse(mc, new boolean[0]);
            throw new GCUBEUnrecoverableException(e).toFault(new String[0]);
        }
    }

    private boolean validateToken(String token, String caller, GCUBEServiceContext context) throws Exception {
        if (token != null) {
            AuthorizationEntry info = this.retrieveTokenInfo(token);
            if (info == null) {
                logger.info("rejecting call to " + caller + ", invalid token " + token);
                throw new Exception("invalid token " + token);
            }
            logger.info("CALL ARRIVED WITH A TOKEN FROM " + info.getClientInfo().getId() + " in scope " + info.getContext() + " in thread " + Thread.currentThread());
            this.checkPolicies(info, context);
            AuthorizationProvider.instance.set(new Caller(info.getClientInfo(), info.getQualifier()));
            GCUBEScope scope = GCUBEScope.getScope(info.getContext());
            logger.trace("Scope = " + scope);
            context.setScope(scope);
            logger.info("retrieved request authorization info " + AuthorizationProvider.instance.get() + " in scope " + ScopeProvider.instance.get());
            SecurityTokenProvider.instance.set(token);
            return true;
        }
        logger.info("token not found");
        return false;
    }

    private AuthorizationEntry retrieveTokenInfo(String token) throws Exception {
        return Constants.authorizationService().get(token);
    }

    public void onFault(MessageContext mc) {
        super.onFault(mc);
        this.onResponse(mc, true);
    }

    private void onResponse(MessageContext mc, boolean ... failure) {
        if (!mc.isPropertyTrue(SERVICECONTEXT_PROPERTY)) {
            return;
        }
        GCUBEServiceContext context = (GCUBEServiceContext)mc.getProperty(SERVICECONTEXT_PROPERTY);
        String caller = (String)mc.getProperty(CALLER_PROPERTY);
        String target = context.getServiceClass() + ":" + context.getName() + ":" + InnerMethodName.instance.get();
        String currentScope = ScopeProvider.instance.get();
        boolean callIsFailed = false;
        context.getManagementBean().setLastResponseTime(context.getTiming());
        context.getManagementBean().addCall();
        if (failure != null && failure.length > 0 && failure[0]) {
            callIsFailed = true;
            context.getManagementBean().addFailedCall();
        }
        context.resetTimer();
        logger.info("END CALL FROM (" + caller + ") TO (" + target + ")," + (currentScope == null ? "INVALID" : currentScope + "," + Thread.currentThread() + ",[" + context.getTiming() + "]"));
        if (GHNContext.getContext().isAccountingEnabled()) {
            if (AuthorizationProvider.instance.get() != null) {
                Caller authEntry = AuthorizationProvider.instance.get();
                this.generateAccounting(authEntry.getClient().getId(), authEntry.getTokenQualifier(), caller, context, callIsFailed);
            } else {
                this.generateAccounting("UNKNOWN", "DEFAULT", caller, context, callIsFailed);
            }
        }
        ScopeProvider.instance.reset();
        startCallThreadLocal.remove();
        SecurityTokenProvider.instance.reset();
        InnerMethodName.instance.reset();
        AuthorizationProvider.instance.reset();
    }

    void generateAccounting(String caller, String callerQualifier, String remoteHost, GCUBEServiceContext serviceContext, boolean isFailed) {
        logger.debug("generating accounting for the current call");
        AccountingPersistenceFactory.setFallbackLocation((String)GHNContext.getContext().getStorageRoot());
        AccountingPersistence persistence = AccountingPersistenceFactory.getPersistence();
        ServiceUsageRecord serviceUsageRecord = new ServiceUsageRecord();
        try {
            serviceUsageRecord.setConsumerId(caller);
            serviceUsageRecord.setCallerQualifier(callerQualifier);
            serviceUsageRecord.setScope(ScopeProvider.instance.get());
            serviceUsageRecord.setServiceClass(serviceContext.getServiceClass());
            serviceUsageRecord.setServiceName(serviceContext.getName());
            serviceUsageRecord.setHost(GHNContext.getContext().getHostnameAndPort());
            serviceUsageRecord.setCalledMethod(InnerMethodName.instance.get());
            serviceUsageRecord.setCallerHost(remoteHost);
            serviceUsageRecord.setOperationResult(isFailed ? UsageRecord.OperationResult.FAILED : UsageRecord.OperationResult.SUCCESS);
            serviceUsageRecord.setDuration(Long.valueOf(System.currentTimeMillis() - startCallThreadLocal.get()));
            persistence.account((Record)serviceUsageRecord);
        }
        catch (Exception ex) {
            logger.warn("invalid record passed to accounting ", ex);
        }
    }

    private void checkPolicies(AuthorizationEntry info, GCUBEServiceContext context) {
        ServiceIdentifier serviceIdentifier = GCUBEHandler.getServiceInfo(context).getServiceIdentifier();
        for (Policy policy : info.getPolicies()) {
            if (!PolicyUtils.isPolicyValidForClient((ServiceAccess)policy.getServiceAccess(), (ServiceIdentifier)serviceIdentifier)) continue;
            logger.error("rejecting call to " + context.getName() + " : " + info.getClientInfo().getId() + " is not allowed to contact the service ");
            throw new RuntimeException("rejecting call to " + context.getName() + ": " + info.getClientInfo().getId() + " is not allowed to contact the service");
        }
    }

    public static ServiceInfo getServiceInfo(GCUBEServiceContext context) {
        String hostedin = String.format("%s_%d", GHNContext.getContext().getHostname(), GHNContext.getContext().getPort());
        return new ServiceInfo(new ServiceIdentifier(context.getName(), context.getServiceClass(), hostedin));
    }
}

