/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.informationsystem.notifier;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.informationsystem.notifier.ISNotifierException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.globus.wsrf.Topic;

public interface ISNotifier {
    public <T extends BaseNotificationConsumer> void registerToISNotification(T var1, List<GCUBENotificationTopic> var2, GCUBESecurityManager var3, GCUBEScope ... var4) throws ISNotifierException;

    public void unregisterFromISNotification(GCUBESecurityManager var1, List<GCUBENotificationTopic> var2, GCUBEScope ... var3) throws ISNotifierException;

    public void registerISNotification(EndpointReferenceType var1, List<? extends Topic> var2, GCUBESecurityManager var3, GCUBEScope ... var4) throws ISNotifierException;

    public void unregisterISNotification(EndpointReferenceType var1, List<? extends Topic> var2, GCUBESecurityManager var3, GCUBEScope ... var4) throws ISNotifierException;

    public boolean[] isTopicRegistered(GCUBESecurityManager var1, GCUBEScope var2, List<TopicData> var3) throws ISNotifierException;

    public static class GCUBENotificationTopic {
        private QName topicQName;
        private String precondition = null;
        private String selector = null;
        private boolean useRenotifier = false;

        public GCUBENotificationTopic(QName topicQName) {
            this.topicQName = topicQName;
        }

        public QName getTopicQName() {
            return this.topicQName;
        }

        public void setTopicQName(QName topicQName) {
            this.topicQName = topicQName;
        }

        public String getPrecondition() {
            return this.precondition;
        }

        public void setPrecondition(String precondition) {
            this.precondition = precondition;
        }

        public String getSelector() {
            return this.selector;
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }

        public boolean isUseRenotifier() {
            return this.useRenotifier;
        }

        public void setUseRenotifier(boolean useRenotifier) {
            this.useRenotifier = useRenotifier;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.precondition == null ? 0 : this.precondition.hashCode());
            result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
            result = 31 * result + (this.topicQName == null ? 0 : this.topicQName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GCUBENotificationTopic other = (GCUBENotificationTopic)obj;
            if (this.precondition == null ? other.precondition != null : !this.precondition.equals(other.precondition)) {
                return false;
            }
            if (this.selector == null ? other.selector != null : !this.selector.equals(other.selector)) {
                return false;
            }
            return !(this.topicQName == null ? other.topicQName != null : !this.topicQName.equals(other.topicQName));
        }
    }

    public static class TopicData {
        private QName topic;
        private EndpointReferenceType epr;

        public TopicData(QName topic, EndpointReferenceType epr) {
            this.topic = topic;
            this.epr = epr;
        }

        public QName getTopic() {
            return this.topic;
        }

        public void setTopic(QName topic) {
            this.topic = topic;
        }

        public EndpointReferenceType getEpr() {
            return this.epr;
        }

        public void setEpr(EndpointReferenceType epr) {
            this.epr = epr;
        }
    }

    public static class NotificationMessage {
        private QName topic;
        private Object message;
        private EndpointReferenceType producer;
        private boolean isRP;

        public NotificationMessage(QName topic, MessageElement[] message, EndpointReferenceType producer) {
            this.topic = topic;
            this.message = message;
            this.producer = producer;
            this.isRP = true;
        }

        public NotificationMessage(QName topic, Object message, EndpointReferenceType producer) {
            this.topic = topic;
            this.message = message;
            this.producer = producer;
            this.isRP = false;
        }

        public QName getTopic() {
            return this.topic;
        }

        public MessageElement[] getMessage() {
            if (this.isRP) {
                return (MessageElement[])this.message;
            }
            return null;
        }

        public Object getMessageObject() {
            if (this.isRP) {
                return null;
            }
            return this.message;
        }

        public EndpointReferenceType getProducer() {
            return this.producer;
        }
    }

    public static class BaseNotificationConsumer
    implements GCUBEConsumer<NotificationTopic, Object> {
        public List<QName> notifications = new ArrayList<QName>();

        @Override
        public <T1 extends NotificationTopic, P1> void onEvent(GCUBEEvent<T1, P1> ... events) {
            if (events == null) {
                return;
            }
            for (GCUBEEvent<T1, P1> event : events) {
                if (this.notifications == null || !this.notifications.contains(((NotificationMessage)event.getPayload()).getTopic())) continue;
                NotificationTopic topic = (NotificationTopic)event.getTopic();
                switch (topic) {
                    case NOTIFICATIONRECEIVED: {
                        this.onNotificationReceived((NotificationEvent)event);
                    }
                }
            }
        }

        protected void onNotificationReceived(NotificationEvent event) {
        }
    }

    public static class NotificationEvent
    extends GCUBEEvent<NotificationTopic, NotificationMessage> {
        public NotificationEvent(NotificationMessage message) {
            this.payload = message;
        }
    }

    public static enum NotificationTopic implements GCUBETopic
    {
        NOTIFICATIONRECEIVED;

    }
}

