/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.proxies;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.core.utils.proxies.GCUBEProxyContext;
import org.gcube.common.core.utils.proxies.GCUBEProxyFactory;

public class ForwardProxyContext
extends GCUBEProxyContext<ReturnProxy> {
    @Override
    public MethodInterceptor getInterceptor(final Object proxied) {
        GCUBELog logger = new GCUBELog(this);
        return new MethodInterceptor(){

            public Object intercept(Object proxy, Method method, Object[] input, MethodProxy methodProxy) throws Throwable {
                GCUBEProxyContext<? extends Annotation> nextContext = null;
                boolean returnProxy = false;
                for (Annotation annotation : proxied.getClass().getMethod(method.getName(), method.getParameterTypes()).getAnnotations()) {
                    if (annotation instanceof ReturnProxy) {
                        if (Modifier.isFinal(method.getReturnType().getModifiers())) continue;
                        returnProxy = true;
                        continue;
                    }
                    GCUBEProxyContext<? extends Annotation> context = GCUBEProxyFactory.getProxy(annotation.annotationType());
                    if (context == null) continue;
                    if (nextContext == null) {
                        nextContext = context;
                        nextContext.setAnnotation(annotation);
                        nextContext.setCaller(new Throwable().getStackTrace()[2]);
                        continue;
                    }
                    throw new Exception("The annotations of method " + method + " cannot be unabiguously resolved (" + nextContext.getClass().getName() + " or " + proxy.getClass().getName() + "?)");
                }
                if (nextContext != null) {
                    return nextContext.getInterceptor(proxied).intercept(proxy, method, input, methodProxy);
                }
                if (returnProxy) {
                    return GCUBEProxyFactory.getProxy(methodProxy.invoke(proxied, input), method.getReturnType());
                }
                return methodProxy.invoke(proxied, input);
            }
        };
    }

    @Override
    public Class<ReturnProxy> getAnnotationClass() {
        return ReturnProxy.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ReturnProxy {
    }
}

