/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.context.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.ConfigurationException;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.gcube.common.core.contexts.GHNClientContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.security.GCUBEClientSecurityManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.context.impl.DefaultGHNSecurityContext;
import org.gcube.common.core.security.utils.ClientCredentialsBean;
import org.gcube.common.core.security.utils.ProxyUtil;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.wsrf.impl.security.descriptor.CredentialParamsParser;
import org.globus.wsrf.impl.security.descriptor.CredentialParamsParserCallback;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DefaultGHNClientSecurityContext
extends DefaultGHNSecurityContext {
    private GCUBELog logger = new GCUBELog(this);

    public DefaultGHNClientSecurityContext() {
        this.init();
    }

    private void init() {
        String pathToDefaultSecurityConfiguration = null;
        try {
            this.logger.debug("Loading client mode default security configuration");
            WSDDDocument document = ((GHNClientContext)GHNContext.getContext()).getServerWsddDocument();
            pathToDefaultSecurityConfiguration = (String)document.getDeployment().getGlobalOptions().get("defaultSecurityConfiguration");
            this.logger.debug(pathToDefaultSecurityConfiguration);
        }
        catch (ConfigurationException e) {
            this.logger.error("Server.wsdd configuration error", e);
        }
        super.init(pathToDefaultSecurityConfiguration);
    }

    @Override
    public Subject getDefaultSubject() {
        if (this.defaultCredentials == null) {
            this.defaultCredentials = this.getDefaultCredentials();
        }
        if (this.defaultSubject == null && this.defaultCredentials != null) {
            try {
                this.defaultSubject = JaasGssUtil.createSubject((GSSCredential)this.defaultCredentials);
            }
            catch (Exception e) {
                this.logger.error("Error in loading the subject ", e);
            }
        }
        return this.defaultSubject;
    }

    @Override
    public GSSCredential getDefaultCredentials() {
        if (this.defaultCredentials == null) {
            try {
                this.logger.debug("Loading client mode container credentials");
                WSDDDocument document = ((GHNClientContext)GHNContext.getContext()).getServerWsddDocument();
                String secDescPath = GHNContext.getContext().getLocation() + File.separatorChar + document.getDeployment().getGlobalConfiguration().getParameter("containerSecDesc");
                this.logger.debug(secDescPath);
                BufferedReader scanner = new BufferedReader(new FileReader(secDescPath));
                StringBuilder builder = new StringBuilder();
                String line = null;
                while ((line = scanner.readLine()) != null) {
                    builder.append(line);
                }
                this.logger.debug("Sec desc " + builder.toString());
                Element rootElement = this.stringToElement(builder.toString());
                NodeList credList = rootElement.getElementsByTagName("credential");
                Element credElement = null;
                if (credList == null || credList.getLength() == 0) {
                    credList = rootElement.getElementsByTagName("proxy-file");
                }
                if (credList != null && credList.getLength() > 0) {
                    credElement = (Element)credList.item(0);
                    ClientCredentialsBean bean = new ClientCredentialsBean();
                    CredentialParamsParser parser = new CredentialParamsParser((CredentialParamsParserCallback)bean);
                    parser.parse(credElement);
                    String proxy = bean.getProxyFile();
                    this.logger.debug("Proxy file = " + proxy);
                    if (proxy != null) {
                        this.defaultCredentials = ProxyUtil.loadProxyCredentials(proxy);
                    } else if (bean.getCertFile() != null && bean.getKeyFile() != null) {
                        String certFile = bean.getCertFile();
                        String keyFile = bean.getKeyFile();
                        this.logger.debug("Cert file = " + certFile);
                        this.logger.debug("Key file = " + keyFile);
                        GlobusCredential globusCredentials = new GlobusCredential(certFile, keyFile);
                        this.defaultCredentials = new GlobusGSSCredentialImpl(globusCredentials, 0);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Unable to load container credentials, some operations could be not available", e);
            }
        }
        return this.defaultCredentials;
    }

    @Override
    public GCUBESecurityManager getDefaultSecurityManager() throws Exception {
        this.logger.debug("Generate default security manager");
        this.logger.debug("Client mode: generating a Client security manager");
        Class<GCUBEClientSecurityManager> securityManagerClass = GCUBEClientSecurityManager.class;
        return GHNContext.getImplementation(securityManagerClass);
    }

    private Element stringToElement(String nodeAsString) throws Exception {
        Document xml = this.string2Document(nodeAsString);
        Element element = xml.getDocumentElement();
        return element;
    }

    private Document string2Document(String xmlString) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }
}

