/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.utils.handlers.GCUBEComplexHandler;
import org.gcube.common.core.utils.handlers.GCUBEIHandler;
import org.gcube.common.core.utils.handlers.lifetime.Lifetime;
import org.gcube.common.core.utils.handlers.lifetime.State;

public class GCUBEParallelHandler<HANDLED>
extends GCUBEComplexHandler<HANDLED>
implements Lifetime<HANDLED> {
    protected Mode mode;
    protected List<SlaveThread> failedSlaves = new ArrayList<SlaveThread>();
    protected List<SlaveThread> runningSlaves = new ArrayList<SlaveThread>();
    protected Map<GCUBEIHandler<? extends HANDLED>, Exception> failedHandlers = new HashMap<GCUBEIHandler<? extends HANDLED>, Exception>();

    public GCUBEParallelHandler(GCUBEIHandler<? extends HANDLED> ... components) {
        super(components);
    }

    public GCUBEParallelHandler(Mode mode) {
        super(new GCUBEIHandler[0]);
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Map<GCUBEIHandler<? extends HANDLED>, Exception> getFailedHandlers() {
        return this.failedHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() throws Exception {
        this.setState(State.Running.INSTANCE);
        GCUBEParallelHandler gCUBEParallelHandler = this;
        synchronized (gCUBEParallelHandler) {
            for (GCUBEIHandler component : this.getHandlers()) {
                SlaveThread slave = new SlaveThread(component);
                if (this.getSecurityManager() != null) {
                    component.setSecurityManager(this.getSecurityManager());
                    this.getSecurityManager().useCredentials(slave, new SecurityCredentials[0]);
                }
                slave.start();
                this.runningSlaves.add(slave);
            }
            while (this.runningSlaves.size() > 0) {
                this.wait();
                for (SlaveThread error : this.failedSlaves) {
                    if (this.mode == Mode.LAX) {
                        this.logger.warn(error.handler.getName() + " has failed", error.exception);
                        continue;
                    }
                    this.logger.error(error.handler.getName() + " has failed", error.exception);
                    new SweeperThread().start();
                    this.setState(State.Failed.INSTANCE);
                    throw new Exception(error.handler.getName() + " has failed", error.exception);
                }
                this.failedSlaves.clear();
            }
            this.setState(State.Done.INSTANCE);
        }
    }

    protected class SweeperThread
    extends Thread {
        protected SweeperThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GCUBEParallelHandler gCUBEParallelHandler = GCUBEParallelHandler.this;
            synchronized (gCUBEParallelHandler) {
                while (GCUBEParallelHandler.this.runningSlaves.size() > 0) {
                    try {
                        GCUBEParallelHandler.this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            GCUBEParallelHandler.this.undo();
        }
    }

    protected class SlaveThread
    extends Thread {
        GCUBEIHandler<? extends HANDLED> handler;
        Exception exception;

        SlaveThread(GCUBEIHandler<? extends HANDLED> handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.handler.run();
            }
            catch (Exception e) {
                this.exception = e;
            }
            GCUBEParallelHandler gCUBEParallelHandler = GCUBEParallelHandler.this;
            synchronized (gCUBEParallelHandler) {
                if (this.exception != null) {
                    GCUBEParallelHandler.this.failedSlaves.add(this);
                    GCUBEParallelHandler.this.failedHandlers.put(this.handler, this.exception);
                }
                GCUBEParallelHandler.this.runningSlaves.remove(this);
                GCUBEParallelHandler.this.notify();
            }
        }
    }

    public static enum Mode {
        STRICT,
        LAX;

    }
}

