/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.utils;

import javax.xml.rpc.Stub;
import org.apache.log4j.Logger;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.ietf.jgss.GSSCredential;

public class ConfigureSecurity {
    private static Logger logger = Logger.getLogger(ConfigureSecurity.class);

    public static void setSecurity(Stub stub, GSSCredential credentials) {
        ConfigureSecurity.setSecurity(stub, true, credentials, "gsi");
    }

    public static void setSecurity(Stub stub, boolean encryption, GSSCredential credentials, String delegation) {
        ConfigureSecurity.setSecurity(stub, encryption, credentials, delegation, 300);
    }

    public static void setSecurity(Stub stub, boolean encryption, GSSCredential credentials, String delegation, int contextLifetime) {
        if (stub == null) {
            throw new NullPointerException("Stub cannot be null to set security");
        }
        if (credentials == null) {
            throw new NullPointerException("Credentials cannot be null to set security");
        }
        if (delegation == null) {
            throw new NullPointerException("Delegation cannot be null to set security");
        }
        String name = null;
        try {
            name = credentials.getName().toString();
        }
        catch (Exception e) {
            logger.error((Object)"Exception retrieving credentials name", (Throwable)e);
            throw new IllegalArgumentException("Cannot retrieve name from credentials");
        }
        logger.debug((Object)("Set security on stub " + stub.getClass().getSimpleName() + "[" + stub.toString() + "] with arguments: encryption(" + encryption + "), credentials(" + name + "), delegation(" + delegation + "), contextLifetime(" + contextLifetime + ")"));
        stub._setProperty("org.globus.gsi.credentials", (Object)credentials);
        if (encryption) {
            stub._setProperty("org.globus.security.secConv.msg.type", (Object)Constants.ENCRYPTION);
        } else {
            stub._setProperty("org.globus.security.secConv.msg.type", (Object)Constants.SIGNATURE);
        }
        stub._setProperty("org.globus.gsi.mode", (Object)delegation);
        stub._setProperty("org.globus.security.context.lifetime", (Object)contextLifetime);
    }
}

