/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.runninginstance.AccessPoint;
import org.gcube.common.core.resources.runninginstance.AvailablePlugins;
import org.gcube.common.core.resources.runninginstance.DeploymentData;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.resources.runninginstance.RunningInstanceInterfaces;
import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.Plugin;
import org.gcube.common.core.resources.service.PortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class Builder {
    private GCUBELog logger;
    private GCUBEServiceContext context;

    public Builder(GCUBEServiceContext context) {
        this.context = context;
    }

    public void setLogger(GCUBELog logger) {
        this.logger = logger;
    }

    public void createRIResource() throws Exception {
        GCUBERunningInstance instance = this.context.getInstance();
        GCUBEService service = this.context.getService();
        GHNContext nodecontext = GHNContext.getContext();
        instance.setResourceVersion(instance.getLastResourceVersion());
        instance.setDescription(service.getDescription());
        instance.setGHNID(nodecontext.getGHNID());
        instance.setServiceClass(service.getServiceClass());
        instance.setServiceName(service.getServiceName());
        instance.setServiceID(service.getID());
        List<Package> pl = service.getPackages();
        for (Package p : pl) {
            if (!p.getClass().isAssignableFrom(MainPackage.class)) continue;
            instance.setInstanceVersion(p.getVersion());
            break;
        }
        this.updateEPRSection(instance, this.context.getService());
        DeploymentData data = new DeploymentData();
        data.setActivationTime(Calendar.getInstance());
        data.setState(this.context.getStatus().toString());
        instance.setDeploymentData(data);
        GCUBEScope[] scopes = this.context.getStartScopes();
        this.logger.info("starting in scopes " + Arrays.asList(scopes));
        if (instance.addScope(scopes).size() == 0) {
            throw new GCUBEResource.InvalidScopeException();
        }
    }

    public void updateRIResource() throws Exception {
        GCUBERunningInstance instance = this.context.getInstance();
        GCUBEService service = this.context.getService();
        GHNContext nodecontext = GHNContext.getContext();
        instance.setGHNID(nodecontext.getGHNID());
        instance.setServiceClass(service.getServiceClass());
        instance.setServiceName(service.getServiceName());
        instance.setServiceID(service.getID());
        List<Package> pl = service.getPackages();
        for (Package p : pl) {
            if (!p.getClass().isAssignableFrom(MainPackage.class)) continue;
            instance.setInstanceVersion(p.getVersion());
            break;
        }
        this.updateEPRSection(instance, this.context.getService());
        instance.getDeploymentData().setActivationTime(Calendar.getInstance());
        instance.getDeploymentData().setState(this.context.getStatus().toString());
    }

    public void addPlugin(GCUBEService service) {
        GCUBERunningInstance instance = this.context.getInstance();
        AvailablePlugins plugins = instance.getDeploymentData().getPlugins();
        AvailablePlugins.AvailablePlugin aplugin = plugins.new AvailablePlugins.AvailablePlugin();
        aplugin.setClazz(service.getServiceClass());
        aplugin.setName(service.getServiceName());
        aplugin.setVersion(service.getVersion());
        for (Package pluginpackage : service.getPackages()) {
            try {
                if (!(pluginpackage instanceof Plugin)) continue;
                aplugin.setPluginPackage(pluginpackage.getName());
                aplugin.setPluginVersion(pluginpackage.getVersion());
                break;
            }
            catch (Exception e) {
            }
        }
        plugins.getPlugins().add(aplugin);
    }

    private void updateEPRSection(GCUBERunningInstance instance, GCUBEService service) throws Exception {
        String riBaseURL;
        try {
            riBaseURL = GHNContext.getContext().getBaseURLToPublish();
            if (this.context.getProperty("publishedHost", false) != null) {
                riBaseURL = riBaseURL.replace(GHNContext.getContext().getHostname(), (String)this.context.getProperty("publishedHost", false));
            }
            if (this.context.getProperty("publishedPort", false) != null) {
                riBaseURL = riBaseURL.replace(Integer.toString(GHNContext.getContext().getPort()), Integer.toString((Integer)this.context.getProperty("publishedPort", false)));
            }
        }
        catch (IOException ioe) {
            this.logger.fatal("unable to detect the base URL", ioe);
            throw ioe;
        }
        AccessPoint access = new AccessPoint();
        RunningInstanceInterfaces ris = new RunningInstanceInterfaces();
        List<Endpoint> eprs = ris.getEndpoint();
        List<Package> packages = service.getPackages();
        for (Package pack : packages) {
            if (!(pack instanceof MainPackage)) continue;
            List<PortType> porttypes = ((MainPackage)pack).getPorttypes();
            for (PortType pt : porttypes) {
                Endpoint epr = new Endpoint();
                epr.setEntryName(pt.getName().trim());
                epr.setValue(riBaseURL + pt.getName().trim());
                eprs.add(epr);
            }
        }
        if (eprs.size() == 0) {
            throw new Exception("No interface found for instance of " + service.getServiceName());
        }
        access.setRunningInstanceInterfaces(ris);
        instance.setAccessPoint(access);
    }

    public void removePlugin(GCUBEService service) {
        GCUBERunningInstance instance = this.context.getInstance();
        AvailablePlugins plugins = instance.getDeploymentData().getPlugins();
        AvailablePlugins.AvailablePlugin pluginToRemove = plugins.new AvailablePlugins.AvailablePlugin();
        pluginToRemove.setClazz(service.getServiceClass());
        pluginToRemove.setName(service.getServiceName());
        pluginToRemove.setVersion(service.getVersion());
        for (Package pluginpackage : service.getPackages()) {
            try {
                if (!(pluginpackage instanceof Plugin)) continue;
                pluginToRemove.setPluginPackage(pluginpackage.getName());
                pluginToRemove.setPluginVersion(pluginpackage.getVersion());
                break;
            }
            catch (Exception e) {
            }
        }
        plugins.getPlugins().remove(pluginToRemove);
    }
}

