/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.service;

import org.gcube.common.core.resources.service.Configuration;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KConfiguration {
    /*
     * Enabled aggressive block sorting
     */
    public static Configuration load(KXmlParser parser) throws Exception {
        Configuration config = new Configuration();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    String tag = parser.getName();
                    if (tag.equals("Static")) {
                        config.setStaticConfig(KStaticConfiguration.load(parser));
                    }
                    if (!tag.equals("Dynamic")) break;
                    config.setDynamicConfig(KDynamicConfiguration.load(parser));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Configuration")) break;
                    return config;
                }
                case 1: {
                    throw new Exception("Parsing failed at Configuration");
                }
            }
        }
    }

    public static void store(Configuration component, KXmlSerializer serializer) throws Exception {
        if (component == null) {
            return;
        }
        serializer.startTag(KGCUBEResource.NS, "Configuration");
        KStaticConfiguration.store(component.getStaticConfig(), serializer);
        KDynamicConfiguration.store(component.getDynamicConfig(), serializer);
        serializer.endTag(KGCUBEResource.NS, "Configuration");
    }

    static class KDynamicConfiguration {
        KDynamicConfiguration() {
        }

        public static Configuration.DynamicConfiguration load(KXmlParser parser) throws Exception {
            Configuration.DynamicConfiguration dynamicConfig = new Configuration.DynamicConfiguration();
            return dynamicConfig;
        }

        public static void store(Configuration.DynamicConfiguration component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "Dynamic");
            serializer.endTag(KGCUBEResource.NS, "Dynamic");
        }
    }

    static class KStaticConfiguration {
        KStaticConfiguration() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public static Configuration.StaticConfiguration load(KXmlParser parser) throws Exception {
            Configuration.StaticConfiguration staticConfig = new Configuration.StaticConfiguration();
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("Config")) {
                            staticConfig.getConfigurations().add(KConfig.load(parser));
                        }
                        if (!parser.getName().equals("Template")) break;
                        staticConfig.setTemplate(KTemplate.load(parser));
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("Static")) break;
                        return staticConfig;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at Static (Configuration)");
                    }
                }
            }
        }

        public static void store(Configuration.StaticConfiguration component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "Static");
            if (component.getConfigurations().size() != 0) {
                serializer.startTag(KGCUBEResource.NS, "Configs");
            }
            for (Configuration.StaticConfiguration.Config c : component.getConfigurations()) {
                KConfig.store(c, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "Configs");
            KTemplate.store(component.getTemplate(), serializer);
            serializer.endTag(KGCUBEResource.NS, "Static");
        }

        static class KTemplateParam {
            KTemplateParam() {
            }

            /*
             * Enabled aggressive block sorting
             */
            public static Configuration.StaticConfiguration.Template.TemplateParam load(KXmlParser parser) throws Exception {
                Configuration.StaticConfiguration.Template.TemplateParam param = new Configuration.StaticConfiguration.Template.TemplateParam();
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("Name")) {
                                param.setName(parser.nextText());
                            }
                            if (parser.getName().equals("Description")) {
                                param.setDescription(parser.nextText());
                            }
                            if (!parser.getName().equals("Value")) break;
                            param.getValues().add(KTemplParamValue.load(parser));
                            break;
                        }
                        case 3: {
                            if (!parser.getName().equals("Param")) break;
                            return param;
                        }
                        case 1: {
                            throw new Exception("Parsing failed at Param (Static Configuration)");
                        }
                    }
                }
            }

            public static void store(Configuration.StaticConfiguration.Template.TemplateParam component, KXmlSerializer serializer) throws Exception {
                if (component == null) {
                    return;
                }
                serializer.startTag(KGCUBEResource.NS, "Param");
                if (component.getName() != null) {
                    serializer.startTag(KGCUBEResource.NS, "Name").text(component.getName()).endTag(KGCUBEResource.NS, "Name");
                }
                if (component.getDescription() != null) {
                    serializer.startTag(KGCUBEResource.NS, "Description").text(component.getDescription()).endTag(KGCUBEResource.NS, "Description");
                }
                if (component.getValues().size() != 0) {
                    serializer.startTag(KGCUBEResource.NS, "AllowedValues");
                }
                for (Configuration.StaticConfiguration.Template.TemplateParam.TemplateParamValue v : component.getValues()) {
                    KTemplParamValue.store(v, serializer);
                }
                serializer.endTag(KGCUBEResource.NS, "AllowedValues");
                serializer.endTag(KGCUBEResource.NS, "Param");
            }

            static class KTemplParamValue {
                KTemplParamValue() {
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public static Configuration.StaticConfiguration.Template.TemplateParam.TemplateParamValue load(KXmlParser parser) throws Exception {
                    Configuration.StaticConfiguration.Template.TemplateParam.TemplateParamValue paramValue = new Configuration.StaticConfiguration.Template.TemplateParam.TemplateParamValue();
                    while (true) {
                        switch (parser.next()) {
                            case 2: {
                                if (parser.getName().equals("Description")) {
                                    paramValue.setDescription(parser.nextText());
                                }
                                if (parser.getName().equals("Literal")) {
                                    paramValue.setLiteral(parser.nextText());
                                }
                                if (parser.getName().equals("Label")) {
                                    paramValue.setLabel(parser.nextText());
                                }
                                paramValue.setDef(Boolean.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "default")));
                                break;
                            }
                            case 3: {
                                if (!parser.getName().equals("Value")) break;
                                return paramValue;
                            }
                            case 1: {
                                throw new Exception("Parsing failed at Value (Static Configuration)");
                            }
                        }
                    }
                }

                public static void store(Configuration.StaticConfiguration.Template.TemplateParam.TemplateParamValue component, KXmlSerializer serializer) throws Exception {
                    if (component == null) {
                        return;
                    }
                    serializer.startTag(KGCUBEResource.NS, "Value");
                    serializer.attribute(KGCUBEResource.NS, "default", component.isDef() + "");
                    if (component.getDescription() != null) {
                        serializer.startTag(KGCUBEResource.NS, "Description").text(component.getDescription()).endTag(KGCUBEResource.NS, "Description");
                    }
                    if (component.getLiteral() != null) {
                        serializer.startTag(KGCUBEResource.NS, "Literal").text(component.getLiteral()).endTag(KGCUBEResource.NS, "Literal");
                    }
                    if (component.getLabel() != null) {
                        serializer.startTag(KGCUBEResource.NS, "Label").text(component.getLabel()).endTag(KGCUBEResource.NS, "Label");
                    }
                    serializer.endTag(KGCUBEResource.NS, "Value");
                }
            }
        }

        static class KTemplate {
            KTemplate() {
            }

            /*
             * Enabled aggressive block sorting
             */
            public static Configuration.StaticConfiguration.Template load(KXmlParser parser) throws Exception {
                Configuration.StaticConfiguration.Template template = new Configuration.StaticConfiguration.Template();
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (!parser.getName().equals("Param")) break;
                            template.getParameters().add(KTemplateParam.load(parser));
                            break;
                        }
                        case 3: {
                            if (!parser.getName().equals("Template")) break;
                            return template;
                        }
                        case 1: {
                            throw new Exception("Parsing failed at Template (Static Configuration)");
                        }
                    }
                }
            }

            public static void store(Configuration.StaticConfiguration.Template component, KXmlSerializer serializer) throws Exception {
                if (component == null) {
                    return;
                }
                if (component.getParameters().size() != 0) {
                    return;
                }
                serializer.startTag(KGCUBEResource.NS, "Template");
                serializer.startTag(KGCUBEResource.NS, "Params");
                for (Configuration.StaticConfiguration.Template.TemplateParam p : component.getParameters()) {
                    KTemplateParam.store(p, serializer);
                }
                serializer.endTag(KGCUBEResource.NS, "Params");
                serializer.endTag(KGCUBEResource.NS, "Template");
            }
        }

        static class KConfig {
            KConfig() {
            }

            /*
             * Enabled aggressive block sorting
             */
            public static Configuration.StaticConfiguration.Config load(KXmlParser parser) throws Exception {
                Configuration.StaticConfiguration.Config config = new Configuration.StaticConfiguration.Config();
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            config.setDefault(Boolean.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "default")));
                            if (parser.getName().equals("File")) {
                                config.setFile(parser.nextText());
                            }
                            if (parser.getName().equals("Description")) {
                                config.setDescription(parser.nextText());
                            }
                            if (!parser.getName().equals("Label")) break;
                            config.setLabel(parser.nextText());
                            break;
                        }
                        case 3: {
                            if (!parser.getName().equals("Config")) break;
                            return config;
                        }
                        case 1: {
                            throw new Exception("Parsing failed at Config (Static Configuration)");
                        }
                    }
                }
            }

            public static void store(Configuration.StaticConfiguration.Config component, KXmlSerializer serializer) throws Exception {
                if (component == null) {
                    return;
                }
                serializer.startTag(KGCUBEResource.NS, "Config");
                serializer.attribute(KGCUBEResource.NS, "default", component.isDefault() + "");
                if (component.getFile() != null) {
                    serializer.startTag(KGCUBEResource.NS, "File").text(component.getFile()).endTag(KGCUBEResource.NS, "File");
                }
                if (component.getDescription() != null) {
                    serializer.startTag(KGCUBEResource.NS, "Description").text(component.getDescription()).endTag(KGCUBEResource.NS, "Description");
                }
                if (component.getLabel() != null) {
                    serializer.startTag(KGCUBEResource.NS, "Label").text(component.getLabel()).endTag(KGCUBEResource.NS, "Label");
                }
                serializer.endTag(KGCUBEResource.NS, "Config");
            }
        }
    }
}

