/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.utils;

import javax.security.auth.Subject;
import org.gcube.common.core.security.utils.ProxyUtil;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class HostCertificateReader {
    static GCUBELog logger = new GCUBELog(HostCertificateReader.class);

    public static int getHostCertificateLifetime() throws SecurityException, GSSException, ExpiredCredentialsException, IndefiniteLifetimeCredentialsException {
        int remainingLifetime;
        block6: {
            GSSCredential hostCredentials = null;
            remainingLifetime = 0;
            try {
                hostCredentials = JaasGssUtil.getCredential((Subject)SecurityManager.getManager().getSystemSubject());
                if (hostCredentials != null) {
                    remainingLifetime = hostCredentials.getRemainingLifetime();
                    if (remainingLifetime == 0) {
                        throw new ExpiredCredentialsException();
                    }
                    if (remainingLifetime == Integer.MAX_VALUE) {
                        throw new IndefiniteLifetimeCredentialsException();
                    }
                    break block6;
                }
                throw new GSSException(remainingLifetime);
            }
            catch (SecurityException e) {
                logger.error("Unable to access the host credentials", e);
                throw e;
            }
            catch (GSSException e) {
                logger.error("Unable to detect the host credentials", e);
                throw e;
            }
        }
        return remainingLifetime;
    }

    public static String getHostCertificateDN() throws SecurityException, GSSException, ExpiredCredentialsException {
        GSSCredential hostCredentials = null;
        int remainingLifetime = 0;
        try {
            hostCredentials = JaasGssUtil.getCredential((Subject)SecurityManager.getManager().getSystemSubject());
            if (hostCredentials != null) {
                return ((Object)hostCredentials.getName()).toString().trim();
            }
            throw new GSSException(remainingLifetime);
        }
        catch (SecurityException e) {
            logger.error("Unable to access the host credentials", e);
            throw e;
        }
        catch (GSSException e) {
            logger.error("Unable to detect the host credentials", e);
            throw e;
        }
    }

    public static String getHostCertificateCA() throws SecurityException, GSSException, Exception {
        ExtendedGSSCredential hostCredentials = null;
        int remainingLifetime = 0;
        String caName = null;
        try {
            hostCredentials = (ExtendedGSSCredential)JaasGssUtil.getCredential((Subject)SecurityManager.getManager().getSystemSubject());
            if (hostCredentials == null) {
                throw new GSSException(remainingLifetime);
            }
            caName = ProxyUtil.getCA(hostCredentials);
        }
        catch (SecurityException e) {
            logger.error("Unable to access the host credentials", e);
            throw e;
        }
        catch (GSSException e) {
            logger.error("Unable to detect the host credentials", e);
            throw e;
        }
        return caName.trim();
    }

    public static class IndefiniteLifetimeCredentialsException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class ExpiredCredentialsException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

