/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.impl.authentication.extendedhandlers;

import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecureResourcePropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.utils.ContextUtils;

public abstract class ExtendedDescriptorHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog((String)ExtendedDescriptorHandler.class.getName());

    public void invoke(MessageContext msgCtx) throws AxisFault {
        String servicePath = ContextUtils.getTargetServicePath((MessageContext)msgCtx);
        if (servicePath == null) {
            return;
        }
        logger.debug((Object)("Service path " + servicePath));
        Resource resource = null;
        try {
            ResourceContext context = ResourceContext.getResourceContext((SOAPMessageContext)msgCtx);
            resource = context.getResource();
        }
        catch (ResourceContextException exp) {
            logger.debug((Object)"Resource does not exist ", (Throwable)exp);
            resource = null;
        }
        catch (ResourceException exp) {
            logger.debug((Object)"Resource does not exist ", (Throwable)exp);
            resource = null;
        }
        ResourceSecurityDescriptor resDesc = null;
        if (resource != null) {
            resDesc = SecureResourcePropertiesHelper.getResourceSecDescriptor((Resource)resource);
        }
        GCUBEDefaultSecurityConfiguration defaultSecurityConfiguration = SecurityContextFactory.getInstance().getSecurityContext().getDefaultServiceSecurityConfiguration();
        ServiceSecurityDescriptor desc = null;
        if (defaultSecurityConfiguration != null && defaultSecurityConfiguration.isInEnabled() && defaultSecurityConfiguration.isInOverride()) {
            logger.debug((Object)"Override security descriptor");
            desc = SecurityContextFactory.getInstance().getSecurityContext().getDefaultIncomingMessagesSecurityDescriptor();
        } else {
            logger.debug((Object)"Trying to load the service security descriptor...");
            try {
                desc = ServiceSecurityConfig.getSecurityDescriptor((String)servicePath);
                logger.debug((Object)("Service security descriptor " + desc));
            }
            catch (ConfigException e) {
                throw AxisFault.makeFault((Exception)((Object)e));
            }
            if (desc == null && defaultSecurityConfiguration != null && defaultSecurityConfiguration.isInEnabled()) {
                logger.debug((Object)"Service security descriptor not found");
                logger.debug((Object)"Loading the default one");
                desc = SecurityContextFactory.getInstance().getSecurityContext().getDefaultIncomingMessagesSecurityDescriptor();
                logger.debug((Object)("Service security descriptor " + desc));
            }
        }
        if (resDesc == null && desc == null) {
            msgCtx.setProperty("org.globus.security.authz.required", (Object)Boolean.FALSE);
        }
        this.handle(msgCtx, resDesc, desc, servicePath);
    }

    public abstract void handle(MessageContext var1, ResourceSecurityDescriptor var2, ServiceSecurityDescriptor var3, String var4) throws AxisFault;
}

