/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.faults.GCUBERetrySameException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEServiceClient;
import org.gcube.common.core.utils.handlers.lifetime.Lifetime;
import org.gcube.common.core.utils.handlers.lifetime.State;

public abstract class GCUBEServiceHandler<CLIENT extends GCUBEServiceClient>
extends GCUBEHandler<CLIENT>
implements Lifetime<CLIENT> {
    private static final String TARGETEPR_NAME = "targetEPR";
    private int attempts = 2;
    private final String DEFAULT_PT_NAME = this.getName();

    public GCUBEServiceHandler() {
    }

    public GCUBEServiceHandler(CLIENT client) {
        super(client);
    }

    @Override
    public void run() throws Exception {
        this.setState(State.Running.INSTANCE);
        try {
            EndpointReferenceType epr;
            if (((GCUBEServiceClient)this.getHandled()).getPortTypeMap() == null) {
                ((GCUBEServiceClient)this.getHandled()).setPortTypeMap(new HashMap<String, EndpointReferenceType>());
            }
            if ((epr = this.getCachedEPR()) != null) {
                try {
                    this.logger.info("using cached instance of " + this.getTargetPortTypeName() + "@ " + epr.getAddress());
                    this._interact(epr);
                    this.setState(State.Done.INSTANCE);
                    return;
                }
                catch (GCUBEUnrecoverableException e) {
                    throw e;
                }
                catch (Exception ignore) {
                    this.logger.warn("failed @ instance " + epr.getAddress(), ignore);
                }
            }
            List<EndpointReferenceType> eprs = this.getInstances();
            EndpointReferenceType successfulEpr = this.tryInstances(eprs);
            this.cacheEPR(successfulEpr);
            this.setState(State.Done.INSTANCE);
        }
        catch (Exception e) {
            this.clearCachedEPR();
            this.setState(State.Failed.INSTANCE);
            throw e;
        }
    }

    protected List<EndpointReferenceType> getInstances() throws NoQueryResultException, Exception {
        this.logger.info("looking for instances of " + this.getTargetPortTypeName());
        List<EndpointReferenceType> eprs = this.findInstances();
        if (this.getCachedEPR() != null) {
            EndpointReferenceType duplicate = null;
            for (EndpointReferenceType epr : eprs) {
                if (!epr.getAddress().equals((Object)this.getCachedEPR().getAddress())) continue;
                duplicate = epr;
            }
            eprs.remove(duplicate);
        }
        if (eprs == null || eprs.size() == 0) {
            throw new NoQueryResultException();
        }
        return eprs;
    }

    protected void _interact(EndpointReferenceType epr) throws Exception {
        try {
            this.interact(epr);
            this.getBlackboard().put(TARGETEPR_NAME, epr);
        }
        catch (GCUBEFault f) {
            f.setFaultMessage("error from " + this.getTargetPortTypeName() + ":" + f.toString());
            throw f.toException();
        }
    }

    protected EndpointReferenceType tryInstances(List<EndpointReferenceType> eprs) throws Exception {
        ArrayList<EndpointReferenceType> busyEprs;
        int attempts = 0;
        Exception lastException = null;
        do {
            busyEprs = new ArrayList<EndpointReferenceType>();
            ++attempts;
            for (EndpointReferenceType epr : eprs) {
                if (epr == null) continue;
                try {
                    this.logger.info("trying instance of " + this.getTargetPortTypeName() + " @ " + epr.getAddress());
                    this._interact(epr);
                    return epr;
                }
                catch (GCUBEUnrecoverableException e) {
                    throw e;
                }
                catch (GCUBERetrySameException e) {
                    lastException = e;
                    this.logger.info("trying again later @ " + epr.getAddress());
                    busyEprs.add(epr);
                }
                catch (GCUBERetryEquivalentException ignoreSilent) {
                    lastException = ignoreSilent;
                    this.logger.warn("instance " + epr.getAddress() + " says " + (ignoreSilent.getMessage() == null ? "" : ":" + ignoreSilent.getMessage()));
                }
                catch (Exception ignoreLoud) {
                    lastException = ignoreLoud;
                    this.logger.error("failed @ instance " + epr.getAddress(), ignoreLoud);
                }
            }
        } while (!(eprs = busyEprs).isEmpty() && attempts < this.getAttempts());
        throw lastException;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    protected void clearCachedEPR() {
        ((GCUBEServiceClient)this.getHandled()).getPortTypeMap().put(this.getCacheKey(), null);
    }

    protected void cacheEPR(EndpointReferenceType epr) {
        this.logger.trace("remembering last useful instance of " + this.getTargetPortTypeName());
        ((GCUBEServiceClient)this.getHandled()).getPortTypeMap().put(this.getCacheKey(), epr);
    }

    protected EndpointReferenceType getCachedEPR() {
        return ((GCUBEServiceClient)this.getHandled()).getPortTypeMap().get(this.getCacheKey());
    }

    protected String getCacheKey() {
        String name = this.getTargetPortTypeName();
        GCUBEScope scope = null;
        if (this.getScopeManager() != null) {
            scope = this.getScopeManager().getScope();
        } else if (((GCUBEServiceClient)this.getHandled()).getScope() != null) {
            scope = ((GCUBEServiceClient)this.getHandled()).getScope();
        }
        return scope == null ? name : name + scope.toString();
    }

    protected String getTargetPortTypeName() {
        return this.DEFAULT_PT_NAME;
    }

    protected abstract List<EndpointReferenceType> findInstances() throws Exception;

    protected abstract void interact(EndpointReferenceType var1) throws Exception;

    public static class NoQueryResultException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

