package org.gcube.common.core.scope;

import java.rmi.Remote;

import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.scope.api.ScopeProvider;

/**
 * The interface of managers of scope information within service implementations.
 * @author Fabio Simeoni (University of Strathclyde)
 *
 */
public interface GCUBEScopeManager {

	/**
	 * Shared {@link GCUBEScopeManager}
	 * @deprecated as to 1.5.1, use {@link ScopeProvider#instance} instead.
	 */
	public static final GCUBEScopeManager DEFAULT = new GCUBEScopeManagerImpl();
	
	/** Name of the service class call header. */
	public static final String CLASS_HEADER_NAME="serviceClass";
	/** Name of the service name call header. */
	public static final String NAME_HEADER_NAME="serviceName";
	/** Name of the scope call header. */
	public static final String SCOPE_HEADER_NAME="scope";
	/** Namespace of scope-related headers */
	public static final String SCOPE_NS="http://gcube-system.org/namespaces/scope";

	/*Models a scope which is not valid with respect to the context of usage. */
	public static class IllegalScopeException extends RuntimeException {static final long serialVersionUID = 1L;}
	/**
	 * Sets the scope of outgoing calls in the current thread.
	 * @param scope the scope.
	 */
	public void setScope(GCUBEScope scope) throws IllegalScopeException;
		
	/**
	 * Sets the scope of outgoing calls in a given thread.
	 * @param thread the thread.
	 * @param scope (optional) the scope. If omitted, it defaults to the scope of the current thread.
	 * @deprecated as to 1.5.1 refactor in term of {@link ScopeProvider#instance}
	 */
	@Deprecated
	public void setScope(Thread thread, GCUBEScope ... scope);

	/**
	 * Gets the scope for outgoing calls in the current thread.
	 * @return the scope;
	 */
	public GCUBEScope getScope();

	/**
	 * Sets the scope for an outgoing call to a target gCube service.
	 * @param remote the stub of the target port-type.
	 * @param clazz the gCube class of the target service.
	 * @param name the gCube name of the target service.
	 * @param scope (optional) the scope of the call. If omitted, the scope associated with the current thread will be used.
	 * @see GCUBERemotePortTypeContext#getProxy(Remote, org.gcube.common.core.contexts.GCUBEServiceContext)
	 * @see GCUBERemotePortTypeContext#getProxy(Remote, GCUBEScope, org.gcube.common.core.security.GCUBESecurityManager...)
	 * @see GCUBERemotePortTypeContext#getProxy(Remote, GCUBEScopeManager, org.gcube.common.core.security.GCUBESecurityManager...)
	 */
	public void prepareCall(Remote remote, String clazz, String name, GCUBEScope ... scope);

}