package org.gcube.common.core.security;

import java.util.Map;

import org.gcube.common.core.contexts.GCUBEServiceContext;

/**
 * 
 * This interface will replace {@link GCUBESecurityController}, {@link GCUBEServiceAuthenticationController} and {@link GCUBEServiceAuthorizationController}
 * to manage the authentication and authorization control. Currently in the security library there is an implementation of {@link GCUBESecurityController} 
 * that will supporth both the paradigms for a certain period: in the next release the old security library will be progressively abandoned 
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public interface GCUBESecurityController 
{
	final String 	SECURITY_ENABLED = "SECURITY_ENABLED",
					SERVER_URL	= "SERVER_URL",
					CREDENTIAL_PROPAGATION_POLICY = "CREDENTIAL_PROPAGATION_POLICY";
	
	/**
	 * 
	 * Inits the controller
	 * 
	 * @param serviceContext
	 */
	public void init (GCUBEServiceContext serviceContext);
	
	
	/**
	 * Checks the access rights (authentication and authorization) 
	 * @param parameters all the needed parameters
	 * @return true if the access is granted, false otherwise
	 */
	public boolean checkAccess (Map<String, Object> parameters);

}
