/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.impl;

import java.rmi.Remote;
import java.util.Map;
import javax.xml.rpc.Stub;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.security.GCUBEClientSecurityManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.security.impl.CredentialManager;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.ietf.jgss.GSSCredential;

public class GCUBECredentialAdder
implements GCUBEClientSecurityManager {
    private GCUBELog logger = new GCUBELog(this);
    private CredentialManager internalCredentialManager = new CredentialManager();
    private int securityStatus = -1;

    @Override
    public void setIdentityParameters(Map<String, String> parameters) throws Exception {
        this.logger.debug("No Identity parameters needed");
    }

    @Override
    public void setDefaultIdentityParameter(String identity) throws Exception {
        this.logger.debug("No Identity parameters needed");
    }

    @Override
    public void forceSecurityEnabled() {
        this.securityStatus = 1;
    }

    @Override
    public void forceSecurityDisabled() {
        this.securityStatus = 0;
    }

    @Override
    public void disableSecurityStatusEnforcement() {
        this.securityStatus = -1;
    }

    @Override
    public SecurityCredentials getClientBaseCredentials() {
        return new GSSSecurityCredentials(SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
    }

    @Override
    public boolean isSecurityEnabled() {
        switch (this.securityStatus) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return GHNContext.getContext().isSecurityEnabled();
    }

    @Override
    @Deprecated
    public synchronized void useCredentials(GSSCredential credentials) throws Exception {
        this.useCredentials(Thread.currentThread(), new GSSSecurityCredentials(credentials));
    }

    @Override
    public synchronized void useCredentials(SecurityCredentials credentials) throws Exception {
        this.useCredentials(Thread.currentThread(), credentials);
    }

    @Override
    public synchronized void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        if (this.isSecurityEnabled()) {
            if (credentials.length == 0) {
                credentials = new SecurityCredentials[]{this.getCredentials()};
            } else if (!this.checkCredentialType(credentials)) {
                throw new Exception("Invalid credentials set");
            }
            this.internalCredentialManager.setCredentials(thread, credentials);
        }
    }

    private boolean checkCredentialType(SecurityCredentials[] credentials) {
        for (SecurityCredentials credential : credentials) {
            if (credential.getCredentialsAsObject() instanceof GSSCredential) continue;
            this.logger.debug("Invalid credentials");
            return false;
        }
        return true;
    }

    @Override
    public SecurityCredentials getCredentials() {
        return this.internalCredentialManager.getCredentials();
    }

    @Override
    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        if (this.isSecurityEnabled()) {
            this.logger.debug("Adding the security credentials");
            this.internalCredentialManager.associateCurrentCredentials((Stub)s);
            this.logger.debug("Security credentials added");
        } else {
            this.logger.debug("Security not enabled, Nothing to do");
        }
    }

    @Override
    public void setAuthMethod(GCUBESecurityManager.AuthMethod m) {
        this.logger.debug("No auth method required");
    }
}

