/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.scope;

import java.rmi.Remote;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.axis.client.Stub;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.utils.logging.GCUBELog;

public class GCUBEScopeManagerImpl
implements GCUBEScopeManager {
    protected GCUBELog logger = new GCUBELog(this);
    protected Map<Thread, GCUBEScope> scopes = Collections.synchronizedMap(new WeakHashMap());
    protected String name = this.getClass().getSimpleName();

    public GCUBEScopeManagerImpl() {
    }

    public GCUBEScopeManagerImpl(GCUBELog logger) {
        this.logger = logger;
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
        this.logger.setPrefix(name);
    }

    @Override
    public void setScope(GCUBEScope scope) {
        this.setScope(Thread.currentThread(), scope);
    }

    public void setScope(Thread thread, GCUBEScope scope) throws GCUBEScopeManager.IllegalScopeException {
        this.setScope(thread, new GCUBEScope[]{scope});
    }

    @Override
    public void setScope(Thread thread, GCUBEScope ... scope) {
        GCUBEScope s;
        GCUBEScope gCUBEScope = s = scope.length == 0 ? this.getScope() : scope[0];
        if (s != null) {
            this.logger.trace("Setting scope " + s + " in " + thread);
        }
        this.scopes.put(thread, s);
    }

    @Override
    public GCUBEScope getScope() {
        return this.scopes.get(Thread.currentThread());
    }

    @Override
    public synchronized void prepareCall(Remote remote, String clazz, String name, GCUBEScope ... scope) {
        if (scope == null || scope.length == 0) {
            scope = new GCUBEScope[]{this.getScope()};
        }
        this.logger.trace("Preparing call to service " + clazz + "," + name + " in scope " + scope[0]);
        Stub stub = (Stub)remote;
        stub.clearHeaders();
        stub.setHeader("http://gcube-system.org/namespaces/scope", "serviceClass", (Object)clazz);
        stub.setHeader("http://gcube-system.org/namespaces/scope", "serviceName", (Object)name);
        stub.setHeader("http://gcube-system.org/namespaces/scope", "scope", scope[0] == null ? null : scope[0].toString());
    }
}

