/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts.service;

import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.logging.GCUBELog;

public class Consumer
implements GCUBEConsumer<GCUBEServiceContext.RILifetimeTopic, GCUBEServiceContext> {
    protected GCUBELog consumerLogger = new GCUBELog(this);

    public void setLogger(GCUBELog logger) {
        this.consumerLogger = logger;
    }

    @Override
    public synchronized <T1 extends GCUBEServiceContext.RILifetimeTopic, P1 extends GCUBEServiceContext> void onEvent(GCUBEEvent<T1, P1> ... events) {
        if (events == null || events.length == 0) {
            return;
        }
        for (GCUBEEvent<T1, P1> e : events) {
            try {
                GCUBEServiceContext.RILifetimeEvent event = (GCUBEServiceContext.RILifetimeEvent)e;
                switch ((GCUBEServiceContext.RILifetimeTopic)event.getTopic()) {
                    case DEPLOYED: {
                        this.onRIDeployed(event);
                        break;
                    }
                    case INITIALISED: {
                        this.onRIInitialised(event);
                        break;
                    }
                    case READY: {
                        this.onRIReady(event);
                        break;
                    }
                    case FAILED: {
                        this.onRIFailed(event);
                        break;
                    }
                    case UPDATED: {
                        this.onRIUpdated(event);
                        break;
                    }
                    case STATECHANGE: {
                        this.onRIStateChange(event);
                        break;
                    }
                    case DOWN: {
                        this.onGHNShutdown(event);
                    }
                }
            }
            catch (Throwable trouble) {
                this.consumerLogger.setContext((GCUBEContext)e.getPayload());
                String errMsg = "Could not process RI event";
                if (e.getTopic() != GCUBEServiceContext.RILifetimeTopic.FAILED) {
                    this.consumerLogger.fatal(errMsg, trouble);
                    ((GCUBEServiceContext)events[0].getPayload()).setStatus(GCUBEServiceContext.Status.FAILED);
                    continue;
                }
                this.consumerLogger.warn(errMsg, trouble);
            }
        }
    }

    public GCUBEServiceContext.RILifetimeTopic[] getTopics() {
        return GCUBEServiceContext.RILifetimeTopic.values();
    }

    protected synchronized void onGHNShutdown(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
    }

    protected synchronized void onRIDeployed(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
    }

    protected synchronized void onRIInitialised(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
    }

    protected synchronized void onRIReady(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
    }

    protected synchronized void onRIFailed(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
    }

    protected synchronized void onRIUpdated(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
    }

    protected synchronized void onRIStateChange(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
    }
}

