package org.gcube.common.core.scope;

import org.gcube.common.core.contexts.GHNContext;

/**
 * A scope of type <code>ROOTVO</code> or <code>SUBVO</code>.  
 */
public class VO extends GCUBEScope {

	protected VO(String name) {
		super(name);
	}
	
	
	/**
	 * {@inheritDoc}
	 */
	public ServiceMap getServiceMap() throws GCUBEScopeNotSupportedException {
		if (this.serviceMap==null) {
			//retrieves the service map from an equivalent scope of the GHN
			GCUBEScope scope = GHNContext.getContext().getGHN().getScopes().get(this.toString());
			if (scope!=null) this.serviceMap = scope.getServiceMap();
			else throw new GCUBEScopeNotSupportedException(scope);
		}
		return this.serviceMap;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setServiceMap(ServiceMap map) {
		this.serviceMap=map;
	}


	
	
}
