package org.gcube.common.core.faults;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;

import javax.xml.namespace.QName;

/**
 * Root of all exceptions with GCUBE semantics.
 * 
 * @author Fabio Simeoni (University of Strathclyde)
 *
 */
public abstract class GCUBEException extends RemoteException {
	
		/** Serial Version ID. */
	private static final long serialVersionUID = 1L;

	/**Creates an exception with a no message and no cause.*/
	public GCUBEException() {super();}
	
	/**Creates an exception with a given message and cause.
	 * @param msg the message.
	 * @param cause the cause.*/
	public GCUBEException(String msg, Throwable cause) {super(msg,cause);}
	
	/**Creates an exception with a given message.
	 * @param msg the message. */
	public GCUBEException(String msg) {super(msg);}
	
	/**Create an exception with a given cause.
	 * @param cause the cause.*/
	public GCUBEException(Throwable cause) {super("",cause);}
	
	/**Returns a stub object of the remote fault class which corresponds to the exception. 
	 * @return the stub object.*/
	public abstract GCUBEFault getFault();
	
	/** Converts the exception into a corresponding remote fault.
	 * @param msg an optional message specific to the new fault.
	 * @return the fault.*/
	public GCUBEFault toFault(String ...msg) {
		
		GCUBEFault fault = this.getFault();		
		
		String errMsg;
		if (msg==null || msg.length==0) 
			errMsg = this.getMessage();
		else 
			errMsg = msg[0]+((this.getMessage()==null || this.getMessage().length()==0)?"":this.getMessage());
		fault.setFaultMessage(errMsg);
		
		//pretty pointless output
		fault.removeFaultDetail(new QName("http://xml.apache.org/axis/","stackTrace"));
		
		try {
			ExceptionProxy proxy = ExceptionProxy.newInstance(this);
			fault.addFaultDetail(proxy.toElement());
		}
		catch(Exception e) {
			//adds whole stacktrace as single detail element
			StringWriter w = new StringWriter();
			this.printStackTrace(new PrintWriter(w));
			fault.addFaultDetailString(w.toString());			
		}
		
		return fault;
	}
}
