/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.lifecycle.application;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gcube.smartgears.lifecycle.State;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ApplicationState implements State<ApplicationState>
{
    started("start"){

        @Override
        public List<ApplicationState> next() {
            return Arrays.asList(active, failed);
        }

        @Override
        public String remoteForm() {
            return "STARTED";
        }
    }
    ,
    active("activation"){

        @Override
        public List<ApplicationState> next() {
            return Arrays.asList(failed, stopped);
        }

        @Override
        public String remoteForm() {
            return "ready";
        }
    }
    ,
    stopped("stop"){

        @Override
        public List<ApplicationState> next() {
            return Arrays.asList(failed, active);
        }

        @Override
        public String remoteForm() {
            return "down";
        }
    }
    ,
    failed("failure"){

        @Override
        public List<ApplicationState> next() {
            return Collections.emptyList();
        }

        @Override
        public String remoteForm() {
            return "failed";
        }
    };

    private final String event;

    private ApplicationState(String event) {
        this.event = event;
    }

    @Override
    public String event() {
        return this.event;
    }
}

