/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.ValidatorFactory;
import org.gcube.common.validator.annotations.IsValid;
import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.smartgears.configuration.AuthorizationProviderConfiguration;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.configuration.PersistenceConfiguration;
import org.gcube.smartgears.configuration.ProxyAddress;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.BaseConfiguration;
import org.gcube.smartgears.configuration.container.Site;

public class ContainerConfiguration {
    @NotNull
    @IsValid
    private BaseConfiguration baseConfiguration;
    @IsValid
    private Map<String, String> properties = new HashMap<String, String>();
    @NotNull
    @IsValid
    private Site site;
    @IsValid
    private ProxyAddress proxy;
    @NotEmpty
    @NotNull
    private String accountingFallbackLocation;
    private List<ApplicationConfiguration> apps = new ArrayList<ApplicationConfiguration>();
    @NotNull
    @IsValid
    private PersistenceConfiguration persistenceConfiguration;
    @NotNull
    @IsValid
    private AuthorizationProviderConfiguration authorizationConfiguration;

    protected void setBaseConfiguration(BaseConfiguration baseConfiguration) {
        this.baseConfiguration = baseConfiguration;
    }

    protected void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    protected void setSite(Site site) {
        this.site = site;
    }

    protected void setProxy(ProxyAddress proxy) {
        this.proxy = proxy;
    }

    protected void setAccountingFallbackLocation(String accountingFallbackLocation) {
        this.accountingFallbackLocation = accountingFallbackLocation;
    }

    protected void setPersistenceConfiguration(PersistenceConfiguration persistenceConfiguration) {
        this.persistenceConfiguration = persistenceConfiguration;
    }

    protected void setAuthorizationProviderConfiguration(AuthorizationProviderConfiguration authorizationConfiguration) {
        this.authorizationConfiguration = authorizationConfiguration;
    }

    public void setApps(List<ApplicationConfiguration> apps) {
        this.apps = apps;
    }

    public Mode mode() {
        return this.baseConfiguration.getMode();
    }

    public boolean checkTokenExpiration() {
        return this.baseConfiguration.checkTokenExpiration();
    }

    public List<ApplicationConfiguration> apps() {
        return this.apps;
    }

    public ApplicationConfiguration app(String context) {
        for (ApplicationConfiguration app : this.apps) {
            if (!context.equals(app.context())) continue;
            return app;
        }
        return null;
    }

    public synchronized ContainerConfiguration app(ApplicationConfiguration app) {
        int indexToRemove = -1;
        int index = 0;
        for (ApplicationConfiguration application : this.apps) {
            if (app.context().equals(application.context())) {
                indexToRemove = index;
            }
            ++index;
        }
        if (indexToRemove != -1) {
            this.apps.remove(indexToRemove);
        }
        this.apps.add(app);
        return this;
    }

    public Site site() {
        return this.site;
    }

    public String infrastructure() {
        return this.baseConfiguration.getInfrastructure();
    }

    public String hostname() {
        return this.baseConfiguration.getHostname();
    }

    public int port() {
        return this.baseConfiguration.getPort();
    }

    public String protocol() {
        return this.baseConfiguration.getProtocol();
    }

    public boolean authorizeChildrenContext() {
        return this.baseConfiguration.isAuthorizeChildrenContext();
    }

    public ProxyAddress proxy() {
        return this.proxy;
    }

    public PersistenceConfiguration persistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    public String accountingFallbackLocation() {
        return this.accountingFallbackLocation;
    }

    public AuthorizationProviderConfiguration authorizationConfiguration() {
        return this.authorizationConfiguration;
    }

    public Map<String, String> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public long publicationFrequency() {
        return this.baseConfiguration.getPublicationFrequencyInSeconds();
    }

    public void validate() {
        ArrayList<String> msgs = new ArrayList<String>();
        Validator validator = ValidatorFactory.validator();
        for (ValidationError error : validator.validate((Object)this)) {
            msgs.add(error.toString());
        }
        if (!msgs.isEmpty()) {
            throw new IllegalStateException("invalid configuration: " + String.valueOf(msgs));
        }
    }

    public String toString() {
        return "ContainerConfiguration [baseConfiguration=" + String.valueOf(this.baseConfiguration) + ", properties=" + String.valueOf(this.properties) + ", site=" + String.valueOf(this.site) + ", proxy=" + String.valueOf(this.proxy) + ", accountingFallbackLocation=" + this.accountingFallbackLocation + ", persistence=" + this.persistenceConfiguration.getImplementationClass().getSimpleName() + ", authorizationProvider=" + String.valueOf(this.authorizationConfiguration) + "]";
    }
}

