/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.smartgears.configuration.PersistenceConfiguration;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.application.ApplicationHandlers;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.lifecycle.ApplicationProfileManager;
import org.gcube.smartgears.handlers.application.request.RequestAccounting;
import org.gcube.smartgears.handlers.application.request.RequestMetrics;
import org.gcube.smartgears.handlers.application.request.RequestValidator;
import org.gcube.smartgears.persistence.LocalWriter;
import org.gcube.smartgears.persistence.LocalWriterConfiguration;
import org.gcube.smartgears.utils.Utils;
import org.yaml.snakeyaml.Yaml;

public class ApplicationConfigurationBinder {
    public ApplicationConfiguration load(InputStream stream) {
        try {
            Yaml yaml = new Yaml();
            ObjectMapper mapper = new ObjectMapper();
            String mapAsString = mapper.writeValueAsString(yaml.load(stream));
            System.out.println(mapAsString);
            ApplicationConfiguration conf = (ApplicationConfiguration)mapper.readValue(mapAsString, ApplicationConfiguration.class);
            if (conf.persistenceConfiguration() == null) {
                String location = String.format("%s/state/%s_%s", Utils.home(), conf.group(), conf.name());
                File dir = new File(location);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                conf.persistenceConfiguration(new PersistenceConfiguration(LocalWriter.class, new LocalWriterConfiguration(location)));
            }
            return conf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ApplicationHandlers bindHandlers(ClassLoader classLoader) {
        LinkedList<RequestHandler> requestHandlers = new LinkedList<RequestHandler>();
        requestHandlers.add(new RequestMetrics());
        requestHandlers.add(new RequestValidator());
        requestHandlers.add(new RequestAccounting());
        LinkedList<ApplicationLifecycleHandler> lifecycleHandlers = new LinkedList<ApplicationLifecycleHandler>();
        lifecycleHandlers.add(new ApplicationProfileManager());
        return new ApplicationHandlers(lifecycleHandlers, requestHandlers);
    }

    public void scanForApplicationHandlers(ClassLoader currentClassLoader) {
    }
}

