package org.gcube.smartgears.lifecycle;

import java.util.List;

/**
 * Represents a state in the lifecycle of a service.
 * 
 * @author Lucio Lelii (ISTI-CNR)
 * @author Luca Frosini (ISTI-CNR)
 *
 * @param <S> the specific state type
 */
public interface State<S extends State<S>> {

	/**
	 * Returns the list of states to which services can transition to from this state.
	 * @return the states
	 */
	public abstract List<S> next();
	
	/**
	 * Returns the event corresponding to this state.
	 * Returns the event associated with this state.
	 * @return the event name
	 */
	public String event();
	
	/**
	 * Returns a serialisation of this state for exchange purposes.
	 * @return the serialized state
	 */
	public String remoteForm();
}
