package org.gcube.smartgears.extensions;

import static java.util.Arrays.*;
import static org.gcube.common.events.impl.Utils.*;

import java.util.HashSet;
import java.util.Set;

import org.gcube.smartgears.extensions.HttpExtension.Method;

/**
 * Represents a method signature for API operations.
 * This class encapsulates HTTP method information along with accepted and produced content types.
 * 
 * @author Luca Frosini (ISTI-CNR)
 */
public class  ApiMethodSignature {
	
	Method method;
	Set<String> requestTypes = new HashSet<String>();
	Set<String> responseTypes = new HashSet<String>();
	
	/**
	 * Creates a new API method signature with the specified HTTP method.
	 * 
	 * @param method the HTTP method
	 */
	public ApiMethodSignature(Method method) {
		notNull("method",method);
		this.method=method;
	}
	
	/**
	 * Specifies the content types that this method accepts.
	 * 
	 * @param types the accepted content types
	 * @return this signature for method chaining
	 */
	public ApiMethodSignature accepts(String ... types) {
		
		notNull("request types",types);
		this.requestTypes.addAll(asList(types));
		return this;
	}
	
	/**
	 * Specifies the content types that this method produces.
	 * 
	 * @param types the produced content types
	 * @return this signature for method chaining
	 */
	public ApiMethodSignature produces(String ... types) {

		notNull("response types",types);
		this.responseTypes.addAll(asList(types));
		return this;
	}
	
	
}