package org.gcube.smartgears.configuration.container;

import static org.gcube.smartgears.Constants.default_container_publication_frequency_in_seconds;

import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.smartgears.configuration.Mode;

/**
 * Base configuration for SmartGears containers.
 * 
 * @author Luca Frosini (ISTI-CNR)
 */
public class BaseConfiguration {

	
	Mode mode = Mode.online;
	
	@NotNull @NotEmpty
	String hostname;
		
	@NotNull
	Integer port;
	
	@NotNull @NotEmpty
	String protocol="http";
	
	boolean authorizeChildrenContext = false;
	
	@NotNull @NotEmpty
	String infrastructure;
	
	long publicationFrequencyInSeconds = default_container_publication_frequency_in_seconds;
	
	@NotNull @NotEmpty
	private Boolean checkTokenExpiration = false;
	
	/**
	 * Returns whether token expiration should be checked.
	 * 
	 * @return true if token expiration should be checked, false otherwise
	 */
	public boolean checkTokenExpiration() {
		return checkTokenExpiration; 
	}
	
	/**
	 * Returns the container mode.
	 * 
	 * @return the mode
	 */
	public Mode getMode() {
		return mode;
	}

	/**
	 * Returns the hostname.
	 * 
	 * @return the hostname
	 */
	public String getHostname() {
		return hostname;
	}

	/**
	 * Returns the port number.
	 * 
	 * @return the port number
	 */
	public Integer getPort() {
		return port;
	}

	/**
	 * Returns the protocol.
	 * 
	 * @return the protocol
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * Returns whether children context authorization is enabled.
	 * 
	 * @return true if children context authorization is enabled, false otherwise
	 */
	public boolean isAuthorizeChildrenContext() {
		return authorizeChildrenContext;
	}

	/**
	 * Returns the infrastructure name.
	 * 
	 * @return the infrastructure name
	 */
	public String getInfrastructure() {
		return infrastructure;
	}



	/**
	 * Returns the publication frequency in seconds.
	 * 
	 * @return the publication frequency in seconds
	 */
	public long getPublicationFrequencyInSeconds() {
		return publicationFrequencyInSeconds;
	}

	/**
	 * Sets the publication frequency in seconds.
	 * 
	 * @param publicationFrequencyInSeconds the publication frequency to set
	 */
	public void setPublicationFrequencyInSeconds(long publicationFrequencyInSeconds) {
		this.publicationFrequencyInSeconds = publicationFrequencyInSeconds;
	}

	/**
	 * Sets the container mode.
	 * 
	 * @param mode the mode to set
	 */
	public void setMode(Mode mode) {
		this.mode = mode;
	}

	/**
	 * Sets the hostname.
	 * 
	 * @param hostname the hostname to set
	 */
	public void setHostname(String hostname) {
		this.hostname = hostname;
	}

	/**
	 * Sets the port number.
	 * 
	 * @param port the port number to set
	 */
	public void setPort(Integer port) {
		this.port = port;
	}

	/**
	 * Sets the protocol.
	 * 
	 * @param protocol the protocol to set
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * Sets whether children context authorization is enabled.
	 * 
	 * @param authorizeChildrenContext true to enable, false to disable
	 */
	public void setAuthorizeChildrenContext(boolean authorizeChildrenContext) {
		this.authorizeChildrenContext = authorizeChildrenContext;
	}

	/**
	 * Sets the infrastructure name.
	 * 
	 * @param infrastructure the infrastructure name to set
	 */
	public void setInfrastructure(String infrastructure) {
		this.infrastructure = infrastructure;
	}


	@Override
	public String toString() {
		return "BaseConfiguration [mode=" + mode + ", hostname=" + hostname + ", port=" + port + ", protocol="
				+ protocol + ", authorizeChildrenContext=" + authorizeChildrenContext + ", infrastructure="
				+ infrastructure + ", publicationFrequency=" + publicationFrequencyInSeconds
				+ "]";
	}
	
	
	
}
