package org.gcube.smartgears.configuration;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation to specify the configuration class for a component.
 * 
 * @author Luca Frosini (ISTI-CNR)
 */
@Retention(RUNTIME)
@Target(ElementType.TYPE)
public @interface ConfiguredWith {

	/**
	 * The configuration class for the component.
	 * 
	 * @return the configuration class
	 */
	public Class<? extends ComponentConfiguration> value();
}
