package org.gcube.smartgears.configuration;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo.As;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo.Id;

/**
 * Base interface for component configurations.
 * 
 * @author Luca Frosini (ISTI-CNR)
 */
@JsonTypeInfo(include=As.PROPERTY, use=Id.CLASS, property= "className")
public interface ComponentConfiguration {

	/**
	 * Returns the location of the component.
	 * 
	 * @return the component location
	 */
	String getLocation();
}
