package org.gcube.smartgears.configuration;

import org.gcube.common.security.credentials.Credentials;
import org.gcube.common.security.factories.AuthorizationProviderFactory;
import org.gcube.common.validator.annotations.IsValid;
import org.gcube.common.validator.annotations.NotNull;

/**
 * Configuration for authorization providers.
 * 
 * @author Luca Frosini (ISTI-CNR)
 */
public class AuthorizationProviderConfiguration {

	@NotNull
	AuthorizationProviderFactory<?> authProviderFactory;
	
	@NotNull @IsValid
	Credentials credentials;
	
	/**
	 * Creates a new authorization provider configuration.
	 * 
	 * @param authProviderFactory the authorization provider factory
	 * @param credentials the credentials
	 */
	public AuthorizationProviderConfiguration(AuthorizationProviderFactory<?> authProviderFactory,
			Credentials credentials) {
		super();
		this.authProviderFactory = authProviderFactory;
		this.credentials = credentials;
	}

	/**
	 * Returns the authorization provider factory.
	 * 
	 * @return the authorization provider factory
	 */
	public AuthorizationProviderFactory<?> getAuthProviderFactory() {
		return authProviderFactory;
	}

	/**
	 * Returns the credentials.
	 * 
	 * @return the credentials
	 */
	public Credentials getCredentials() {
		return credentials;
	}

	@Override
	public String toString() {
		return "AuthorizationProviderConfiguration [authProviderFactory=" + authProviderFactory.getClass() + "]";
	}
	
	
}
