/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.utils;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.records.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcubeAccountingValve
extends ValveBase {
    private static Logger log = LoggerFactory.getLogger(GcubeAccountingValve.class);
    private String infra;
    private String serviceClass;
    private String serviceName;
    private String hostAndPort;

    public void setInfra(String infra) {
        this.infra = infra;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setHostAndPort(String hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            String callerIp = request.getHeader("x-forwarded-for");
            if (callerIp == null) {
                callerIp = request.getRemoteAddr();
            }
            boolean success = response.getStatus() < 400;
            ScopeProvider.instance.set(this.infra);
            AccountingPersistenceFactory.setFallbackLocation((String)"/tmp");
            AccountingPersistence persistence = AccountingPersistenceFactory.getPersistence();
            ServiceUsageRecord serviceUsageRecord = new ServiceUsageRecord();
            try {
                serviceUsageRecord.setConsumerId("UNKNOWN");
                serviceUsageRecord.setCallerQualifier("UNKNOWN");
                serviceUsageRecord.setScope(this.infra);
                serviceUsageRecord.setServiceClass(this.serviceClass);
                serviceUsageRecord.setServiceName(this.serviceName);
                serviceUsageRecord.setDuration(Long.valueOf(200L));
                serviceUsageRecord.setHost(this.hostAndPort);
                serviceUsageRecord.setCalledMethod(request.getRequestURI());
                serviceUsageRecord.setCallerHost(callerIp);
                serviceUsageRecord.setOperationResult(success ? UsageRecord.OperationResult.SUCCESS : UsageRecord.OperationResult.FAILED);
                persistence.account((Record)serviceUsageRecord);
                log.info("Request: {} {} {} {} ", new Object[]{this.infra, request.getContextPath(), request.getRequestURI(), success});
            }
            catch (Exception ex) {
                log.warn("invalid record passed to accounting ", (Throwable)ex);
            }
            finally {
                ScopeProvider.instance.reset();
            }
        }
        catch (Exception e) {
            log.error("error executing valve", (Throwable)e);
        }
        this.getNext().invoke(request, response);
    }
}

