/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.ValidatorFactory;
import org.gcube.common.validator.annotations.IsValid;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.w3c.dom.Element;

@XmlRootElement(name="handlers")
public class ApplicationHandlers {
    @XmlElement(name="lifecycle")
    @IsValid
    private LifecycleHandlers lifecycleHandlers = new LifecycleHandlers();
    @XmlElement(name="request")
    @IsValid
    private RequestHandlers requestHandlers = new RequestHandlers();

    public List<ApplicationLifecycleHandler> lifecycleHandlers() {
        return this.lifecycleHandlers.values;
    }

    public ApplicationHandlers set(ApplicationLifecycleHandler ... handlers) {
        this.lifecycleHandlers = new LifecycleHandlers(Arrays.asList(handlers));
        return this;
    }

    public List<RequestHandler> requestHandlers() {
        return this.requestHandlers.values;
    }

    public ApplicationHandlers set(RequestHandler ... handlers) {
        this.requestHandlers = new RequestHandlers(Arrays.asList(handlers));
        return this;
    }

    public void validate() {
        ArrayList<String> msgs = new ArrayList<String>();
        Validator validator = ValidatorFactory.validator();
        for (ValidationError error : validator.validate((Object)this)) {
            msgs.add(error.toString());
        }
        if (!msgs.isEmpty()) {
            throw new IllegalStateException("invalid configuration: " + msgs);
        }
    }

    public void mergeWith(ApplicationHandlers other) {
        List<ApplicationLifecycleHandler> lifecycles = other.lifecycleHandlers();
        for (ApplicationLifecycleHandler handler : lifecycles) {
            if (this.lifecycleHandlers().contains(handler)) continue;
            this.lifecycleHandlers().add(handler);
        }
        List<RequestHandler> requests = other.requestHandlers();
        for (RequestHandler handler : requests) {
            if (this.requestHandlers().contains(handler)) continue;
            this.requestHandlers().add(handler);
        }
    }

    private static class RequestHandlers {
        @XmlAnyElement(lax=true)
        List<RequestHandler> values = new ArrayList<RequestHandler>();

        RequestHandlers() {
        }

        RequestHandlers(List<RequestHandler> handlers) {
            this.values = handlers;
        }

        void afterUnmarshal(Unmarshaller u, Object parent) {
            for (RequestHandler o : this.values) {
                if (!(o instanceof Element)) continue;
                throw new RuntimeException("invalid handler detected in configuration: " + ((Element)Element.class.cast(o)).getLocalName());
            }
        }
    }

    private static class LifecycleHandlers {
        @XmlAnyElement(lax=true)
        List<ApplicationLifecycleHandler> values = new ArrayList<ApplicationLifecycleHandler>();

        LifecycleHandlers() {
        }

        LifecycleHandlers(List<ApplicationLifecycleHandler> handlers) {
            this.values = handlers;
        }

        void afterUnmarshal(Unmarshaller u, Object parent) {
            for (ApplicationLifecycleHandler o : this.values) {
                if (!(o instanceof Element)) continue;
                throw new RuntimeException("invalid handler detected in configuration: " + ((Element)Element.class.cast(o)).getLocalName());
            }
        }
    }
}

