/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="context-retriever")
public class RequestContextRetriever
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestContextRetriever.class);

    @Override
    public String getName() {
        return "context-retriever";
    }

    @Override
    public void handleRequest(RequestEvent call) {
        String scope;
        String token = call.request().getParameter("gcube-token") == null ? call.request().getHeader("gcube-token") : call.request().getParameter("gcube-token");
        String string = scope = call.request().getParameter("gcube-scope") == null ? call.request().getHeader("gcube-scope") : call.request().getParameter("gcube-scope");
        if (token == null && call.request().getHeader("Authorization") != null) {
            String basicAuthorization = call.request().getHeader("Authorization");
            String base64Credentials = basicAuthorization.substring("Basic".length()).trim();
            String credentials = new String(DatatypeConverter.parseBase64Binary((String)base64Credentials));
            String[] values = credentials.split(":", 2);
            token = values[1];
        }
        if (token == null && scope == null && call.request().getParameter("client_secret") != null) {
            token = call.request().getParameter("client_secret");
        }
        if (token != null) {
            this.retreiveAndSetInfo(token, call);
        } else if (scope != null) {
            ScopeProvider.instance.set(scope);
        }
    }

    @Override
    public void handleResponse(ResponseEvent e) {
        SecurityTokenProvider.instance.reset();
        AuthorizationProvider.instance.reset();
        ScopeProvider.instance.reset();
        log.debug("resetting all the Thread local for this call.");
    }

    private void retreiveAndSetInfo(String token, RequestEvent call) {
        log.info("retrieving context using token {} ", (Object)token);
        AuthorizationEntry authEntry = null;
        try {
            authEntry = Constants.authorizationService().get(token);
        }
        catch (ObjectNotFound onf) {
            log.warn("rejecting call to {}, invalid token {}", (Object)((ApplicationContext)call.context()).name(), (Object)token);
            RequestError.invalid_request_error.fire(String.valueOf(((ApplicationContext)call.context()).name()) + " invalid token : " + token);
        }
        catch (Exception e) {
            log.error("error contacting authorization service", (Throwable)e);
            RequestError.internal_server_error.fire("error contacting authorization service");
        }
        AuthorizationProvider.instance.set(new Caller(authEntry.getClientInfo(), authEntry.getQualifier()));
        SecurityTokenProvider.instance.set(token);
        ScopeProvider.instance.set(authEntry.getContext());
        log.info("retrieved request authorization info {} in scope {} ", (Object)AuthorizationProvider.instance.get(), (Object)authEntry.getContext());
    }
}

