/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.container.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePublisher {
    private static final Logger log = LoggerFactory.getLogger(ProfilePublisher.class);
    private final ScopedPublisher publisher;
    private final ContainerContext context;
    private AuthorizationProxy authProxy;

    public ProfilePublisher(ContainerContext context) {
        this.context = context;
        this.publisher = ProviderFactory.provider().publisherFor(context);
        this.authProxy = ProviderFactory.provider().authorizationProxy();
    }

    public void addTo(Collection<String> tokens) {
        HostingNode profile;
        block6: {
            Utils.notEmpty("tokens", tokens);
            log.info("publishing container with tokens {}", tokens);
            profile = this.context.profile(HostingNode.class);
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            String previousToken = SecurityTokenProvider.instance.get();
            try {
                try {
                    if (previousToken == null) {
                        SecurityTokenProvider.instance.set((String)tokens.toArray()[0]);
                    }
                    Thread.currentThread().setContextClassLoader(ProfilePublisher.class.getClassLoader());
                    profile = (HostingNode)this.publisher.create((Resource)profile, this.resolveScopesFromTokens(tokens));
                }
                catch (Exception e) {
                    Utils.rethrowUnchecked(e);
                    SecurityTokenProvider.instance.set(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SecurityTokenProvider.instance.set(previousToken);
                Thread.currentThread().setContextClassLoader(contextCL);
                throw throwable;
            }
            SecurityTokenProvider.instance.set(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        this.sharePublished(profile);
    }

    public void addToAll() {
        this.addTo(this.context.configuration().startTokens());
    }

    public void update() {
        HostingNode profile;
        block6: {
            profile = this.context.profile(HostingNode.class);
            log.debug("[update] resource scopes are : {} ", (Object)profile.scopes().asCollection());
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            String previousToken = SecurityTokenProvider.instance.get();
            try {
                try {
                    if (previousToken == null) {
                        SecurityTokenProvider.instance.set((String)this.context.configuration().startTokens().toArray()[0]);
                    }
                    Thread.currentThread().setContextClassLoader(ProfilePublisher.class.getClassLoader());
                    profile = (HostingNode)this.publisher.update((Resource)profile);
                }
                catch (Exception e) {
                    Utils.rethrowUnchecked(e);
                    SecurityTokenProvider.instance.set(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SecurityTokenProvider.instance.set(previousToken);
                Thread.currentThread().setContextClassLoader(contextCL);
                throw throwable;
            }
            SecurityTokenProvider.instance.set(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        this.sharePublished(profile);
    }

    public void removeFrom(Collection<String> tokens) {
        HostingNode profile;
        block6: {
            profile = this.context.profile(HostingNode.class);
            log.info("removing container with tokens {}", tokens);
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            String previousToken = SecurityTokenProvider.instance.get();
            try {
                try {
                    if (previousToken == null) {
                        SecurityTokenProvider.instance.set((String)tokens.toArray()[0]);
                    }
                    Thread.currentThread().setContextClassLoader(ProfilePublisher.class.getClassLoader());
                    profile = (HostingNode)this.publisher.remove((Resource)profile, this.resolveScopesFromTokens(tokens));
                }
                catch (Exception e) {
                    Utils.rethrowUnchecked(e);
                    SecurityTokenProvider.instance.set(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SecurityTokenProvider.instance.set(previousToken);
                Thread.currentThread().setContextClassLoader(contextCL);
                throw throwable;
            }
            SecurityTokenProvider.instance.set(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        log.debug("after remove container profile contains scopes {}", (Object)profile.scopes().asCollection());
        this.sharePublished(profile);
    }

    private void sharePublished(HostingNode profile) {
        this.context.events().fire((Object)profile, new String[]{"published"});
    }

    private List<String> resolveScopesFromTokens(Collection<String> tokens) {
        ArrayList<String> scopes = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            try {
                scopes.add(this.authProxy.get(token).getContext());
            }
            catch (Exception e) {
                log.warn("error retrieving token {} , it should never happen", (Object)token);
            }
        }
        return scopes;
    }
}

