/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;

public class RequestEvent
extends ApplicationEvent<RequestHandler> {
    private final String servlet;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public RequestEvent(String servlet, ApplicationContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context);
        this.request = request;
        this.response = response;
        this.servlet = servlet;
    }

    public String servlet() {
        return this.servlet;
    }

    public String uri() {
        String query = this.request().getQueryString();
        return query == null ? this.request().getRequestURI() : String.valueOf(this.request().getRequestURI()) + "?" + query;
    }

    public HttpServletRequest request() {
        return this.request;
    }

    public HttpServletResponse response() {
        return this.response;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[req=" + this.request().getRemoteHost() + ",resp=" + this.response.toString().substring(0, 12) + "]";
    }
}

